% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemInputOutputTable_8_8.R
\name{gemInputOutputTable_8_8}
\alias{gemInputOutputTable_8_8}
\title{A General Equilibrium Model based on an 8x8 Input-Output Table}
\usage{
gemInputOutputTable_8_8(
  IT,
  OT,
  es.agri = 0,
  es.manu = 0,
  es.serv = 0,
  es.CI = 0,
  es.FT = 0,
  es.VA.agri = 0.25,
  es.VA.manu = 0.5,
  es.VA.serv = 0.8,
  es.prodDM = 0.5,
  ...
)
}
\arguments{
\item{IT}{the input part of the input-output table in the base period (unit: trillion yuan).}

\item{OT}{the output part of the input-output table in the base period (unit: trillion yuan).}

\item{es.agri, es.manu, es.serv}{the elasticity of substitution between the intermediate input
and the value-added input of the agriculture sector, manufacturing sector and service sector.}

\item{es.CI}{the elasticity of substitution among products used by the CI sector.}

\item{es.FT}{the elasticity of substitution among exported products.}

\item{es.VA.agri, es.VA.manu, es.VA.serv}{the elasticity of substitution between labor input and capital input
of the agriculture sector, manufacturing sector and service sector.}

\item{es.prodDM}{the elasticity of substitution between domestic product and imported product.}

\item{...}{arguments to be transferred to the function sdm of the package CGE.}
}
\value{
A general equilibrium, which is a list with the following elements:
\itemize{
\item p - the price vector with labor as numeraire.
\item D - the demand matrix, also called the input table. Wherein the benchmark prices are used.
\item DV - the demand value matrix, also called the value input table. Wherein the current price is used.
\item SV - the supply value matrix, also called the value output table. Wherein the current price is used.
\item value.added - the value-added of the three production sectors.
\item dstl - the demand structure tree list of sectors.
\item ... - some elements returned by the CGE::sdm function
}
}
\description{
This is a general equilibrium model based on a 8x8 input-output table.
}
\details{
Given an 8x8 input-output table, this model calculates
the corresponding general equilibrium.
This input-output table contains 3 production sectors, 1 consumption and (temporarily unproductive) investment sector (CI sector), 1 foreign trade sector importing agriculture goods,
1 foreign trade sector importing manufacturing goods, 1 foreign trade sector importing service, 1 foreign trade sector importing bond.
There are 8 kinds of commodities (or subjects) in the table, i.e. agriculture product,
manufacturing product, service, labor, capital goods, tax, dividend and bond of ROW (i.e. the rest of the world).
The CI sector uses products and supplies labor, capital, stock and tax receipt.
Generally speaking, the value of the elasticity of substitution in this model should be between 0 and 1.
}
\examples{
\donttest{
IT17 <- matrix(c(
  1.47, 6.47, 0.57, 2.99, 0.12 * 0.60 / (0.60 + 12.10 + 2.23 + 1.45),
  0.12 * 12.10 / (0.60 + 12.10 + 2.23 + 1.45),
  0.12 * 2.23 / (0.60 + 12.10 + 2.23 + 1.45),
  0.12 * 1.45 / (0.60 + 12.10 + 2.23 + 1.45),

  2.18, 76.32, 12.83, 43, 13.30 * 0.60 / (0.60 + 12.10 + 2.23 + 1.45),
  13.30 * 12.10 / (0.60 + 12.10 + 2.23 + 1.45),
  13.30 * 2.23 / (0.60 + 12.10 + 2.23 + 1.45),
  13.30 * 1.45 / (0.60 + 12.10 + 2.23 + 1.45),


  0.82, 19.47, 23.33, 34.88, 2.96 * 0.60 / (0.60 + 12.10 + 2.23 + 1.45),
  2.96 * 12.10 / (0.60 + 12.10 + 2.23 + 1.45),
  2.96 * 2.23 / (0.60 + 12.10 + 2.23 + 1.45),
  2.96 * 1.45 / (0.60 + 12.10 + 2.23 + 1.45),

  6.53, 13.92, 21.88, 0, 0, 0, 0, 0,
  0.23, 4.05, 6.76, 0, 0, 0, 0, 0,
  0, 6.43, 3.40, 0, 0, 0, 0, 0,
  0.13, 8.87, 10.46, 0, 0, 0, 0, 0,
  0, 0, 0, 1.45, 0, 0, 0, 0
), 8, 8, TRUE)

OT17 <- matrix(c(
  11.02, 0, 0, 0, 0.60, 0, 0, 0,
  0, 135.53, 0, 0, 0, 12.10, 0, 0,
  0, 0, 79.23, 0, 0, 0, 2.23, 0,
  0, 0, 0, 42.33, 0, 0, 0, 0,
  0, 0, 0, 11.04, 0, 0, 0, 0,
  0.34, 0, 0, 9.49, 0, 0, 0, 0,
  0, 0, 0, 19.46, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 1.45
), 8, 8, TRUE)

rownames(IT17) <- rownames(OT17) <-
  c("agri", "manu", "serv", "lab", "cap", "tax", "dividend", "bond.ROW")
colnames(IT17) <- colnames(OT17) <- c(
  "sector.agri", "sector.manu", "sector.serv", "sector.CI",
  "sector.FT.agri", "sector.FT.manu", "sector.FT.serv", "sector.FT.bond.ROW"
)


ge <- gemInputOutputTable_8_8(
  IT = IT17,
  OT = OT17
)

#### technology progress
IT.TP <- IT17
IT.TP ["lab", "sector.manu"] <-
  IT.TP ["lab", "sector.manu"] * 0.9

geTP <- gemInputOutputTable_8_8(
  IT = IT.TP,
  OT = OT17
)

geTP$z / ge$z
geTP$p / ge$p
geTP$value.added
prop.table(geTP$value.added) - prop.table(ge$value.added)

#### capital accumulation
OT.CA <- OT17
OT.CA["cap", "sector.CI"] <- OT.CA["cap", "sector.CI"] * 1.1
geCA <- gemInputOutputTable_8_8(
  IT = IT17,
  OT = OT.CA
)

geCA$z / ge$z
geCA$p / ge$p
geCA$p
geCA$value.added
prop.table(geCA$value.added) - prop.table(ge$value.added)

#### tax change
OT.TC <- OT17
OT.TC["tax", "sector.agri"] <- OT.TC["tax", "sector.agri"] * 2

geTC <- gemInputOutputTable_8_8(
  IT = IT17,
  OT = OT.TC
)

geTC$z / ge$z
geTC$p / ge$p

##
IT.TC2 <- IT17
IT.TC2["tax", "sector.manu"] <- IT.TC2["tax", "sector.manu"] * 0.8

geTC2 <- gemInputOutputTable_8_8(
  IT = IT.TC2,
  OT = OT17
)

geTC2$z / ge$z
geTC2$p / ge$p
}
}
