% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gd.R
\name{gd}
\alias{gd}
\alias{print.gd}
\alias{plot.gd}
\title{Geographical detectors: factor detector.}
\usage{
gd(formula, data = NULL)
\method{print}{gd}(x, ...)
\method{plot}{gd}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables}

\item{data}{A data.frame includes response and explanatory variables}

\item{x}{A list of factor detector results}

\item{...}{Ignore}
}
\description{
Function for calculating power determinant using factor detector
of geographical detectors and visualization.
}
\examples{
g1 <- gd(NDVIchange ~ Climatezone, data = ndvi_40)
g1
\donttest{
data <- ndvi_40[,1:3]
g2 <- gd(NDVIchange ~ ., data = data)
g2
}

}
