
## This file is part of the FuzzyStatTraEOO package

#' @title Package 'FuzzyStatTra' in Encapsulated Object Oriented Programming
#'
#' @description
#' \pkg{'FuzzyStatTraEOO'} is an open source package for R.
#' The aim of the package is to contain the package 'FuzzyStatTra' in
#' Encapsulated Object Oriented Programming using R6. 'FuzzyStatTra' contains Statistical
#' Methods for Trapezoidal Fuzzy Numbers, whose aim is to provide some basic functions
#' for doing statistical analysis with trapezoidal fuzzy numbers. For more details,
#' you can visit the website of the SMIRE+CoDiRE (Statistical Methods with Imprecise
#' Random Elements and Comparison of Distributions of Random Elements) Research
#' Group (<https://bellman.ciencias.uniovi.es/smire+codire/>). The most related
#' paper can be found in References. Now, those functions are organized in specific
#' classes and methods.
#' This object-based approach is an important step in making statistical computing
#' more accessible to users.
#'
#' @details
#' Package: FuzzyStatTraEOO\cr
#' Type: Package\cr
#' Version: 1.0\cr
#' Date: 2022-12-12\cr
#' License: LGPL (>= 3)\cr\cr
#' For a complete list of classes and their methods call \code{help(package="FuzzyStatTraEOO")},
#' call \code{??FuzzyStatTraEOO} or use the Index link below, at the end of this help window.
#'
#' @name FuzzyStatTraEOO-package
#'
#' @docType package
#'
#' @author Andrea Garcia Cernuda \email{uo270115@uniovi.es},\cr Asun Lubiano
#' \email{lubiano@@uniovi.es} and Sara de la Rosa de Saa.\cr\cr
#' Maintainer: Andrea Garcia Cernuda \email{uo270115@uniovi.es}
#'
#' @references
#' \itemize{
#'    \item Blanco-Fernandez, A.; Casals, R.M.; Colubi, A.; Corral, N.; Garcia-Barzana, M.;
#'    Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano, M.A.; Montenegro, M.;
#'    Ramos-Guajardo, A.B.; de la Rosa de Saa, S.; Sinova, B.: Random fuzzy sets: A
#'    mathematical tool to develop statistical fuzzy data analysis, Iranian Journal on
#'    Fuzzy Systems 10(2), 1-28 (2013)
#'    \item De la Rosa de Saa, S.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano
#'    M.A.: Fuzzy rating scale-based questionnaires and their statistical analysis, IEEE
#'    Transactions on Fuzzy Systems 23(1), 111-126 (2015)
#'    \item De la Rosa de Sáa, S.; Lubiano, M.A.; Sinova, B.; Filzmoser, P.; Gil, M.Á.: Location-free
#'    robust scale estimates for fuzzy data, IEEE Transactions on Fuzzy Systems 29(6), 1682-1694
#'    (2021)
#'    \item De la Rosa de Saa, S.; Lubiano M.A.; Sinova, B.; Filzmoser, P.: Robust scale
#'    estimators for fuzzy data, Advances in Data Analysis and Classification 11(4), 731-758
#'    (2017)
#'    \item Diamond, P.; Kloeden, P.: Metric spaces of fuzzy sets, Fuzzy Sets and Systems 35,
#'    241-249 (1990)
#'    \item Gil, M.A.; Lubiano, M.A.; De la Rosa de Saa, S.; Sinova, B.: Analyzing data from a
#'    fuzzy rating scale-based questionnaire. A case study, Psicothema 27(2), 182-191 (2015)
#'    \item Lubiano, M.A.; De la Rosa de Saa, S.; Montenegro, M.; Sinova, B.; Gil, M.A.:
#'    Descriptive analysis of responses to items in questionnaires. Why not a fuzzy rating
#'    scale?, Information Sciences 360, 131-148 (2016)
#'    \item Lubiano, M.A.; Gil, M.A.: f-Inequality indices for fuzzy random variables, in Statistical
#'    Modeling, Analysis and Management of Fuzzy Data (Bertoluzza, C., Gil, M.A., Ralescu, D.A., Eds.),
#'    Physica-Verlag, 43-63 (2002)
#'    \item Lubiano, M.A.; Montenegro, M.; Sinova, B.; De la Rosa de Saa, S.; Gil, M.A.: Hypothesis
#'    testing for means in connection with fuzzy rating scale-based data: algorithms and applications,
#'    European Journal of Operational Research 251, 918-929 (2016)
#'    \item Lubiano, M.A.; Salas, A.; Carleos, C.; De la Rosa de Sáa, S.; Gil, M.Á.: Hypothesis
#'    testing-based comparative analysis between rating scales for intrinsically imprecise data,
#'    International Journal of Approximate Reasoning 88, 128-147 (2017)
#'    \item Lubiano, M.A.; Salas, A.; Gil, M.Á.: A hypothesis testing-based discussion on the
#'    sensitivity of means of Fuzzy data with respect to data shape, Fuzzy Sets and Systems 328(1),
#'    54-69 (2017)
#'    \item Sinova, B.; De la Rosa de Saa, S.; Gil, M.A.: A generalized L1-type metric between fuzzy
#'    numbers for an approach to central tendency of fuzzy data, Information Sciences 242, 22-34 (2013)
#'    \item Sinova, B.; De la Rosa de Saa, S.; Lubiano, M.A.; Gil, M.A.: An overview on the statistical
#'    central tendency for fuzzy datasets, International Journal of Uncertainty, Fuzziness and
#'    Knowledge-Based Systems 23 (Suppl. 1), 105-132 (2015)
#'    \item Sinova, B.; Gil, M.A.; Colubi, A.; Van Aelst, S.: The median of a random fuzzy number. The
#'    1-norm distance approach, Fuzzy Sets and Systems 200, 99-115 (2012)
#'    \item Sinova, B.; Gil, M.A.; Lopez, M.T.; Van Aelst, S.: A parameterized L2 metric between fuzzy
#'    numbers and its parameter interpretation, Fuzzy Sets and Systems 245, 101-115 (2014)
#'    \item Sinova, B.; Gil, M.A.; Van Aelst, S.: M-estimates of location for the robust central
#'    tendency of fuzzy data, IEEE Transactions on Fuzzy Systems 24(4), 945-956 (2016)
#' }
#'
#' @keywords package
#' @seealso
#' \url{https://bellman.ciencias.uniovi.es/smire+codire/FuzzyStatTraRpackage.html}
#'
#' @import R6

invisible(NULL)
