% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleCTest.R
\name{OneSampleCTest}
\alias{OneSampleCTest}
\title{Calculate p-value of the one-sample test for the mean}
\usage{
OneSampleCTest(
  initialSample,
  mu_0,
  numberOfSamples = 100,
  theta = 1/3,
  resamplingMethod = classicalBootstrap,
  increases = FALSE
)
}
\arguments{
\item{initialSample}{The initial sample which consists of triangular or trapezoidal fuzzy numbers.
More than one value can be given in the form of matrix.}

\item{mu_0}{Triangular or trapezoidal fuzzy number which is used for the null hypothesis of the C-test.}

\item{numberOfSamples}{Number of the bootstrapped samples used to estimate the p-value.}

\item{theta}{The weighting parameter for the mid/spread distance applied in the C-test.}

\item{resamplingMethod}{Name of the resampling method, which is used to generate the bootstrapped samples.
For the possible names check the values of \code{resamplingMethods} vector.}

\item{increases}{If \code{TRUE} is used, then the fuzzy numbers should be given in the form:
left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers should be given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}
}
\value{
This function returns double value which is equal to the p-value of the one-sample C-test.
}
\description{
\code{OneSampleCTest} returns the p-value of the one-sample test for the mean using the resampling method.
}
\details{
The input fuzzy values should be triangular or trapezoidal fuzzy numbers, given as a single vector or a whole matrix.
In each row, there should be a single fuzzy number in one of the forms:
\enumerate{
\item left end of the support, left end of the core, right end of the core, right end of the support, or
\item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
In this second case, the parameter \code{increases=TRUE} has to be used.

The procedure uses the resampling method given in the \code{resamplingMethod} parameter to estimate the p-value of the one-sample
test for the mean (denoted further as the one-sample C-test, see Lubiano et al. (2016)).
This test checks the null hypothesis that the Aumann-type mean of the fuzzy numbers is equal to a given fuzzy number \code{mu_0}.
}
\examples{

# prepare some fuzzy numbers (first type of the initial sample)

fuzzyValues <- matrix(c(0.25,0.5,1,1.25,0.75,1,1.5,2.2,-1,0,0,2),ncol = 4,byrow = TRUE)

# seed PRNG

set.seed(1234)

# calculate the p-value using the classical (i.e. Efron's) bootstrap

OneSampleCTest(fuzzyValues, mu_0 = c(0,0.5,1,1.5))

# calculate the p-value using the VA resampling method

OneSampleCTest(fuzzyValues, mu_0 = c(0,0.5,1,1.5),resamplingMethod = VAmethod)


}
\references{
Lubiano, M.A., Montenegro M., Sinova, B., de Saa, S.R., Gil, M.A. (2016)
Hypothesis testing for means in connection with fuzzy rating scale-based data: algorithms and applications
European Journal of Operational Research, 251, pp. 918-929
}
\seealso{
\code{\link{TwoSampleCTest}} for the two-sample C-test

Other bootstrapped version of test: 
\code{\link{TwoSampleCTest}()}
}
\concept{bootstrapped version of test}
