% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq_predicate.R
\name{eq_predicate}
\alias{eq_predicate}
\title{Fuzzy predicate poverty estimation}
\usage{
eq_predicate(predicate, ncomp, age, scale.eq, newscale)
}
\arguments{
\item{predicate}{A numeric vector representing the poverty predicate (i.e. income or expenditure)}

\item{ncomp}{A numerical vector of the total number of components for the j-th family.}

\item{age}{A numerical vector of the number of components for the j-th family less than 16 years-old}

\item{scale.eq}{The equivalence scale. Options are: Carbonaro, n.par (non parametric), OECD7050, modifiedOECD or new}

\item{newscale}{a data.frame with two columns: "ncomp"  defining the number of components and  "s.eq" that define the corresponding
value of equivalent people. It is to define only if scale.eq ="new"}
}
\value{
A data.frame containing the equivalised predicate variable.
}
\description{
This function takes as input a numeric vector representing a predicate variable and turns it into its equivalised version
using different equivalence scales.
}
\examples{

pred=runif(100, 0, 1000) #predicate

ncomp=rep(c(1,3,5,7,4),20)

age16=ncomp-1

eq_predicate(predicate=pred, ncomp=ncomp, scale.eq="carbonaro") #carbonaro

eq_predicate(predicate=pred, ncomp=ncomp, scale.eq="n.par") #non-parametric

eq_predicate(predicate=pred, ncomp=ncomp, age=age16, scale.eq="OECD7050") #OECD7050

eq_predicate(predicate=pred, ncomp=ncomp, age=age16, scale.eq="modifiedOECD") #modifiedOECD

#Define a new scale

newscal=data.frame("ncomp"=c(1:9), "s.eq"=runif(9,1,10)) # new

ncomp=rep(c(10,3,5,7,4),20)

eq_predicate(predicate=pred, ncomp=ncomp,scale.eq="new", newscale=newscal)

}
\references{
Bernini, C., Emili, S., & Ferrante, M. R. (2024). Regional disparities in the sensitivity of wellbeing to poverty measures. In Spatial Inequalities and Wellbeing (pp. 136-157). Edward Elgar Publishing.

Betti, G. (1999). Nonparametric equivalence scales with application to Poland. Statistics Research Report.

Chanfreau, J., & Burchardt, T. (2008). Equivalence scales: rationales, uses and assumptions. Edinburgh: Scottish Government.
}
