% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fm_chakravarty.R
\name{fm_Chakravarty}
\alias{fm_Chakravarty}
\title{Fuzzy monetary poverty estimation}
\usage{
fm_Chakravarty(x, z, weight, breakdown, ID)
}
\arguments{
\item{x}{A numeric vector of a poverty predicate}

\item{z}{The parameter of the f.m. function (see Chakravarty (2006))}

\item{weight}{A numeric vector of sampling weights. if NULL simple random sampling weights will be used.}

\item{breakdown}{A factor of sub-domains to calculate estimates for (using the same alpha).}

\item{ID}{A numeric or character vector of IDs. if NULL (the default) it is set as the row sequence.}
}
\value{
The membership grades
}
\description{
Fuzzy monetary poverty estimation
}
\examples{
x = rchisq(1000, 15)
breakdown = sample(letters, size = length(x), replace = TRUE )
fm_construct(predicate = x, weight = NULL, breakdown = breakdown, fm = "chakravarty", z = 10)

}
\references{
Chakravarty, S. R. (2019). An axiomatic approach to multidimensional poverty measurement via fuzzy sets. Poverty, social exclusion and stochastic dominance, 123-141.
}
