% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcc_show_block_matrix.R
\name{funcc_show_block_matrix}
\alias{funcc_show_block_matrix}
\title{Plotting co-clustering results of funCC on the data matrix}
\usage{
funcc_show_block_matrix(fun_mat, res_input)
}
\arguments{
\item{fun_mat}{The data array (n x m x T) where each entry corresponds to the measure of one observation i, i=1,...,n, for a functional variable m, m=1,...,p, at point t, t=1,...,T}

\item{res_input}{An object produced by the funcc_biclust function}
}
\value{
a figure representing the bi-clusters positions in the original data matrix
}
\description{
funcc_show_block_matrix graphically shows the bi-clusters positions in the original data matrix
}
\examples{
 
data("funCCdata")
res <- funcc_biclust(funCCdata,delta=10,theta=1,alpha=1,beta=0,const_alpha=TRUE)
funcc_show_block_matrix(funCCdata,res)
}
