% Generated by roxygen2 (4.0.1): do not edit by hand
\name{BKA}
\alias{BKA}
\title{Bankier-Kalton-Anderson single frame estimator}
\usage{
BKA(ysA, ysB, pi_A, pi_B, pik_ab_B, pik_ba_A, domains_A, domains_B,
conf_level = NULL)
}
\arguments{
\item{ysA}{A numeric vector of length \eqn{n_A} or a numeric matrix or data frame of dimensions \eqn{n_A} x \eqn{c} containing information about variable(s) of interest from \eqn{s_A}.}

\item{ysB}{A numeric vector of length \eqn{n_B} or a numeric matrix or data frame of dimensions \eqn{n_B} x \eqn{c} containing information about variable(s) of interest from \eqn{s_B}.}

\item{pi_A}{A numeric vector of length \eqn{n_A} or a square numeric matrix of dimension \eqn{n_A} containing first order or first and second order inclusion probabilities for units included in \eqn{s_A}.}

\item{pi_B}{A numeric vector of length \eqn{n_B} or a square numeric matrix of dimension \eqn{n_B} containing first order or first and second order inclusion probabilities for units included in \eqn{s_B}.}

\item{pik_ab_B}{A numeric vector of size \eqn{n_A} containing first order inclusion probabilities according to sampling design in frame B for units belonging
to overlap domain that have been selected in \eqn{s_A}.}

\item{pik_ba_A}{A numeric vector of size \eqn{n_B} containing first order inclusion probabilities according to sampling design in frame A for units belonging
to overlap domain that have been selected in \eqn{s_B}.}

\item{domains_A}{A character vector of size \eqn{n_A} indicating the domain each unit from \eqn{s_A} belongs to. Possible values are "a" and "ab".}

\item{domains_B}{A character vector of size \eqn{n_B} indicating the domain each unit from \eqn{s_B} belongs to. Possible values are "b" and "ba".}

\item{conf_level}{(Optional) A numeric value indicating the confidence level for the confidence intervals, if desired.}
}
\value{
A numeric matrix containing Bankier-Kalton-Anderson single frame estimations of population total and population mean for considered values.
}
\description{
Produces estimates for population total and mean using the Bankier-Kalton-Anderson single frame estimator from survey data obtained
 from a dual frame sampling design. Confidence intervals are also computed, if required.
}
\details{
Single frame estimator of population total is given by
 \deqn{\hat{Y}_{BKA} = \sum_{i \in s_A}\tilde{d}_i^Ay_i + \sum_{i \in s_B}\tilde{d}_i^By_i}
 where
 \eqn{\tilde{d}_i^A =\left\{\begin{array}{lcc}
 d_i^A & \textrm{if } i \in a\\
 (1/d_i^A + 1/d_i^B)^{-1} & \textrm{if } i \in ab
 \end{array}
 \right.}
 and
 \eqn{\tilde{d}_i^B =\left\{\begin{array}{lcc}
 d_i^B & \textrm{if } i \in b\\
 (1/d_i^A + 1/d_i^B)^{-1} & \textrm{if } i \in ba
 \end{array}
 \right.}
 being \eqn{d_i^A} and \eqn{d_i^B} the design weights, obtained as the inverse of the first order inclusion probabilities, that is, \eqn{d_i^A = 1/\pi_i^A} and \eqn{d_i^B = 1/\pi_i^B}.

 To estimate variance of this estimator, one uses following approach proposed by Rao and Skinner (1996)
 \deqn{\hat{V}(\hat{Y}_{BKA}) = \hat{V}(\tilde{z}_i^A) + \hat{V}(\tilde{z}_i^B)}
 with \eqn{\tilde{z}_i^A = \delta_i(a)y_i + (1 - \delta_i(a))y_i\pi_i^A/(\pi_i^A + \pi_i^B)} and \eqn{\tilde{z}_i^B = \delta_i(b)y_i + (1 - \delta_i(b))y_i\pi_i^B/(\pi_i^A + \pi_i^B)},
 being \eqn{\delta_i(a)} and \eqn{\delta_i(b)} the indicator variables for domain \eqn{a} and domain \eqn{b}, respectively.
}
\examples{
data(HouseholdsA)
dataA <- attach(HouseholdsA)
detach(HouseholdsA)
data(HouseholdsB)
dataB <- attach(HouseholdsB)
detach(HouseholdsB)
data(PiklA)
data(PiklB)

#Let calculate single frame estimator for population total for variable Leisure
BKA(dataA$Leisure, dataB$Leisure, PiklA, PiklB, dataA$ProbB, dataB$ProbA,
dataA$Domain, dataB$Domain)

#Now, let calculate single frame estimator and a 90\% confidence interval for population
#total for variable Feeding considering only first order inclusion probabilities
BKA(dataA$Feeding, dataB$Feeding, dataA$ProbA, dataB$ProbB, dataA$ProbB,
dataB$ProbA, dataA$Domain, dataB$Domain, 0.90)
}
\references{
Bankier, M. D. (1986)
 \emph{Estimators Based on Several Stratified Samples With Applications to Multiple Frame Surveys}.
 Journal of the American Statistical Association, Vol. 81, 1074 - 1079.

Kalton, G. and Anderson, D. W. (1986)
 \emph{Sampling Rare Populations}.
 Journal of the Royal Statistical Society, Ser. A, Vol. 149, 65 - 82.

Rao, J. N. K. and Skinner, C. J. (1996)
\emph{Estimation in Dual Frame Surveys with Complex Designs}.
Proceedings of the Survey Method Section, Statistical Society of Canada, 63 - 68.

Skinner, C. J. and Rao, J. N. K. (1996)
 \emph{Estimation in Dual Frame Surveys with Complex Designs}.
Journal of the American Statistical Association, Vol. 91, 433, 349 - 356.
}
\seealso{
\code{\link{JackBKA}}
}

