% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FormShare.R
\name{FormShare}
\alias{FormShare}
\title{An R6 Class Representing a connection to FormShare}
\description{
The main FormShare class.
}
\details{
This class encapsulates all functions to execute analytics in FormShare.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# This class requires an API key and secret
# you can get one at https://formshare.org/
#
# Create a new connection to FormShare
my_connection = FormShare$new(server_url = "https://formshare.org",
user_id = "my_user",api_key = "my_api_key",api_secret = "my_api_secret")

# Log in with your account credentials
my_connection$login()

# Get the repositories that your account has access to
repositories = my_connection$get_repositories()

# Get the tables in a repository
tables = my_connection$get_tables("a_repository")

# Get the fields in a table
fields = my_connection$get_fields("a_repository", "a_table")

# Execute a SQL
data = my_connection$execute("a_repository", "SELECT * FROM maintable")

# Get the data from a table
data = my_connection$get_table("a_repository", "a_table")
\dontshow{\}) # examplesIf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{user_id}}{The user ID in FormShare.}

\item{\code{api_key}}{The API key used to connect to FormShare.}

\item{\code{api_secret}}{The API secret used to connect to FormShare}

\item{\code{server_url}}{The FormShare server to connect to}

\item{\code{logged_in}}{Whether the used has a valid connection}

\item{\code{api_token}}{Token to use in other functions}

\item{\code{token_url}}{FormShare URL to retrieve a valid token}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FormShare-new}{\code{FormShare$new()}}
\item \href{#method-FormShare-get_api_key}{\code{FormShare$get_api_key()}}
\item \href{#method-FormShare-set_api_key}{\code{FormShare$set_api_key()}}
\item \href{#method-FormShare-get_api_secret}{\code{FormShare$get_api_secret()}}
\item \href{#method-FormShare-set_api_secret}{\code{FormShare$set_api_secret()}}
\item \href{#method-FormShare-get_server_url}{\code{FormShare$get_server_url()}}
\item \href{#method-FormShare-set_server_url}{\code{FormShare$set_server_url()}}
\item \href{#method-FormShare-login}{\code{FormShare$login()}}
\item \href{#method-FormShare-get_repositories}{\code{FormShare$get_repositories()}}
\item \href{#method-FormShare-get_tables}{\code{FormShare$get_tables()}}
\item \href{#method-FormShare-get_fields}{\code{FormShare$get_fields()}}
\item \href{#method-FormShare-execute}{\code{FormShare$execute()}}
\item \href{#method-FormShare-get_table}{\code{FormShare$get_table()}}
\item \href{#method-FormShare-clone}{\code{FormShare$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-new"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-new}{}}}
\subsection{Method \code{new()}}{
Create a new FormShare object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$new(
  server_url = "https://formshare.org",
  user_id = "",
  api_key = "",
  api_secret = ""
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{server_url}}{Server URL. By default https://formshare.org}

\item{\code{user_id}}{The user ID to use}

\item{\code{api_key}}{The API Key to use.}

\item{\code{api_secret}}{The API Secret to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{FormShare} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_api_key"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_api_key}{}}}
\subsection{Method \code{get_api_key()}}{
Get the current API key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_api_key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-set_api_key"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-set_api_key}{}}}
\subsection{Method \code{set_api_key()}}{
Sets the current API key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$set_api_key(new_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_key}}{New API key}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_api_secret"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_api_secret}{}}}
\subsection{Method \code{get_api_secret()}}{
Get the current API secret
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_api_secret()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-set_api_secret"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-set_api_secret}{}}}
\subsection{Method \code{set_api_secret()}}{
Sets the current API secret.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$set_api_secret(new_secret)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_secret}}{New API secret}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_server_url"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_server_url}{}}}
\subsection{Method \code{get_server_url()}}{
Get the current server URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_server_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-set_server_url"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-set_server_url}{}}}
\subsection{Method \code{set_server_url()}}{
Sets the current server URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$set_server_url(new_url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_url}}{New server URL}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-login"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-login}{}}}
\subsection{Method \code{login()}}{
Log-in to the FormShare server and stores a API token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$login()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
True of False if the connection was successful.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_repositories"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_repositories}{}}}
\subsection{Method \code{get_repositories()}}{
Return the repositories that the user has access to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_repositories()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame with repositories that the user has access to.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_tables"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_tables}{}}}
\subsection{Method \code{get_tables()}}{
Get the tables in a repository.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_tables(repository)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repository}}{The repository to use}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with tables inside a repository.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_fields"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_fields}{}}}
\subsection{Method \code{get_fields()}}{
Get the fields in a table of a repository.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_fields(repository, table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repository}}{The repository to use}

\item{\code{table}}{The table to use}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with fields inside a table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-execute"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-execute}{}}}
\subsection{Method \code{execute()}}{
Executes an SQL and returns it result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$execute(repository, sql)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repository}}{The repository to use}

\item{\code{sql}}{SQL to execute}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with the result of the execution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-get_table"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-get_table}{}}}
\subsection{Method \code{get_table()}}{
A convenient function to return the contents of a table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$get_table(repository, table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repository}}{The repository to use}

\item{\code{table}}{Table to retrieve}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame with data of the table
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FormShare-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FormShare-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FormShare$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
