% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_standard_bv.R
\name{h_standard_bv}
\alias{h_standard_bv}
\title{Calculate Tree Heights with the Bavarian Standard Height Curve System}
\usage{
h_standard_bv(species_id, dbh_cm, age_yr, d_q_cm, h_q_m)
}
\arguments{
\item{species_id}{Vector of species id's following the \emph{tum_wwk_short} or the
\emph{bavrn_state_short} species coding. If another coding is provided, an
attempt will be made to convert it into the "nearest" of the two codings
mentioned above. The default is a conversion attempt to \emph{tum_wwk_short}.
The species id's can also be provided as numeric values
(\code{double} or \code{integer}) or \code{character}. These will be
interpreted as and converted to \code{fe_species_tum_wwk_short}.
If all conversion attempts fail, the function will terminate with an
error.}

\item{dbh_cm}{Vector of tree dbh values in cm (dbh = stem diameter at breast
height, i.e. 1.3 m)}

\item{age_yr}{Vector of stand age values in years (will be recycled following
the rules for tibbles)}

\item{d_q_cm}{Vector of quadratic mean stand diameters (will be recycled
following the rules for tibbles)}

\item{h_q_m}{Vector of quadratic mean stand heights (will be recycled
following the rules for tibbles)}
}
\value{
A vector of the estimated heights
}
\description{
Implementation of the standard height curve system used by the Bavarian State
Forest Service \insertCite{kennel_r_beech_bavaria_1972}{ForestElementsR}. The
structure of the approach was developed by R. Kennel together with a
parameterisation for European beech (Fagus sylvatica). Later, anonymous
scientists have extended the parameters for all species (groups) covered by
the \emph{tum_wwk_short} species coding. The standard height curve system
allows to estimate a tree's height when its dbh is given together with the
quadratic mean diameter, the corresponding quadratic mean height, and the age
of the stand it belongs to.
}
\details{
In order to provide maximum flexibility in applying the function
h_standard_bv, the stand values (age, mean height, mean diameter) can be
provided with each tree diameter individually. This allows estimating heights
for trees from different stands at the same time. In the same way, the
provided species codes are not required to be the same for each tree.
}
\examples{
  species_id <- fe_species_tum_wwk_short(rep(3, 7))  # Seven Scots pines
  dbh <- c(10.1, 27.4, 31.4, 35.5, 39.8, 45.2, 47.2) # and their diameters
  # Estimate the heights of these trees assuming they are from a 100 year old
  # stand with a mean diameter of 35.5 cm, and a corresponding mean height
  # of 28 m.
  h_standard_bv(species_id, dbh, age_yr = 100, d_q_cm = 35.5, h_q_m = 28.0)

  # Compare with sister function h_standard_gnfi3 which does not require
  # stand age
  h_standard_gnfi3(species_id, dbh, d_q_cm = 35.5, h_q_m = 28.0)

}
\references{
\insertAllCited{}
}
\seealso{
Other standard height curve systems: 
\code{\link{h_standard_gnfi3}()}
}
\concept{standard height curve systems}
