% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stand_sums_static.R
\name{stand_sums_static}
\alias{stand_sums_static}
\title{Static Stand Sum and Mean Values for an fe_stand Object}
\usage{
stand_sums_static(x, tree_filter = TRUE, hd_dom_method = c("Weise", "Assmann"))
}
\arguments{
\item{x}{An \code{\link{fe_stand}} object}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). While many
meaningful filterings are conceivable, distinctions between total stand,
removal stand, and remaining stand are the most probable applications.
Defaults to \code{TRUE}, i.e. all trees are included. See examples.}

\item{hd_dom_method}{Method for calculationg the dominant diameter and
dominant height. The default choice is "Weise", using the functions
\code{\link{d_dom_weise}}, and \code{\link{h_dom_weise}}. Alternatively,
the option "Assmann" uses the functions \code{\link{d_100}}, and
\code{\link{h_100}}.}
}
\value{
A data frame (tibble) with the ha-related static sum values stem
number, basal area, volume, quadratic mean diameter, dominant diameter,
quadratic mean height, dominant height. If no tree in \code{x$trees} passes
\code{tree_filter}, as defined above, an empty data frame is returned. In
case an object of class \code{fe_ccircle_spatial_notrees} (which is a
special child of \code{\link{fe_stand}}) is provided as input \code{x}, the
function also returns an empty data frame.
}
\description{
Calculate ha-wise static stand sum and mean values for a fe_stand object. The
term 'static' means that no growth and increment variables are calculated,
only descriptive variables for each point in time.
}
\details{
Default setting for the dominant heights and diameters is the method by
Weise, i.e. quadratic mean diameter and height for the 20\% biggest trees.
Alternatively, the d100, h100 method by Assmann can be selected. This should
be, however, done with care, because d100 and h100 are only well defined
in monospecific stands. Note, that this function does not take into account
species shares in mixed stands when calculating d100 and h100.
}
\examples{
# Evaluation for all trees
mm_forest_1_fe_stand_spatial |> stand_sums_static()

# Exclude removal trees
mm_forest_1_fe_stand_spatial |> stand_sums_static(!removal)

# Exclude removal trees and include only trees with dbh > 30 cm
mm_forest_1_fe_stand_spatial |> stand_sums_static(!removal & dbh_cm > 30)

# Exclude removal trees, use Assmann's d100 h100 for dominant height
# and diameter
mm_forest_1_fe_stand_spatial |>
  stand_sums_static(!removal, hd_dom_method = "Assmann")

# Include all trees, use Assmann's d100 h100 for dominant height
# and diameter
mm_forest_1_fe_stand_spatial |>
  stand_sums_static(hd_dom_method = "Assmann")

}
