% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_entropy.R
\name{continuous_entropy}
\alias{continuous_entropy}
\title{Shannon entropy for a continuous pdf}
\usage{
continuous_entropy(pdf, lower, upper, base = 2)
}
\arguments{
\item{pdf}{R function for the pdf \eqn{p(x)} of a RV \eqn{X \sim p(x)}. This function must
be non-negative and integrate to \eqn{1} over the interval [\code{lower}, \code{upper}].}

\item{lower, upper}{lower and upper integration limit. \code{pdf} must integrate to 
\code{1} on this interval.}

\item{base}{logarithm base; entropy is measured in ``nats'' for 
\code{base = exp(1)}; in ``bits'' if \code{base = 2} (default).}
}
\value{
scalar; entropy value (real). 

Since \code{continuous_entropy} uses numerical integration (\code{integrate()}) convergence
is not garantueed (even if integral in definition of \eqn{\mathcal{H}(p)} exists).
Issues a warning if \code{integrate()} does not converge.
}
\description{
Computes the Shannon entropy \eqn{\mathcal{H}(p)} for a continuous 
probability density function (pdf) \eqn{p(x)} using numerical integration.
}
\details{
The Shannon entropy of a continuous random variable (RV) \eqn{X \sim p(x)} is defined as
\deqn{
\mathcal{H}(p) = -\int_{-\infty}^{\infty} p(x) \log p(x) d x.
}

Contrary to discrete RVs, continuous RVs can have negative entropy (see Examples).
}
\examples{
# entropy of U(a, b) = log(b - a). Thus not necessarily positive anymore, e.g.
continuous_entropy(function(x) dunif(x, 0, 0.5), 0, 0.5) # log2(0.5)

# Same, but for U(-1, 1)
my_density <- function(x){
  dunif(x, -1, 1)
}
continuous_entropy(my_density, -1, 1) # = log(upper - lower)

# a 'triangle' distribution
continuous_entropy(function(x) x, 0, sqrt(2))

}
\seealso{
\code{\link{discrete_entropy}}
}
\keyword{math}
\keyword{univar}

