% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/foreca.one_weightvector-utils.R
\name{foreca.one_weightvector-utils}
\alias{foreca.one_weightvector-utils}
\alias{plot.foreca.one_weightvector}
\alias{summary.foreca.one_weightvector}
\title{Plot, summary, and print methods for class 'foreca.one_weightvector'}
\usage{
\method{summary}{foreca.one_weightvector}(object, lag = 10, alpha = 0.05,
  ...)

\method{plot}{foreca.one_weightvector}(x, main = "", cex.lab = 1.1, ...)
}
\arguments{
\item{lag}{integer; how many lags to test in \code{\link[stats]{Box.test}};
default: \eqn{10}.}

\item{alpha}{significance level for testing white noise in
\code{\link[stats]{Box.test}}; default: \eqn{0.05}.}

\item{...}{additional arguments passed to
\code{\link[graphics]{plot}}, or \code{\link[base]{summary}}.}

\item{x,object}{an object of class \code{"foreca.one_weightvector"}.}

\item{main}{an overall title for the plot: see \code{\link[graphics]{title}}.}

\item{cex.lab}{size of the axes labels.}
}
\description{
S3 methods for the one weightvector optimization in ForeCA
(class \code{"foreca.one_weightvector"}).

\code{summary.foreca.one_weightvector} computes summary statistics.

\code{plot.foreca.one_weightvector} shows the results of an (iterative)
algorithm that obtained the i-th optimal a weightvector
\eqn{\mathbf{w}_i^*}.  It
shows trace plots of the objective function and the weightvector, and a time series
plot of the transformed signal \eqn{y_t^*} along with its spectral density estimate
\eqn{\widehat{f}_y(\omega_j)}.
}
\examples{
# see examples in 'foreca.one_weightvector'
}
\keyword{hplot}
\keyword{manip}

