% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftoneDoptimal_log_GLM_func.R
\name{liftoneDoptimal_log_GLM_func}
\alias{liftoneDoptimal_log_GLM_func}
\title{Lift-one algorithm for D-optimal approximate design in log scale}
\usage{
liftoneDoptimal_log_GLM_func(
  X,
  w,
  reltol = 1e-05,
  maxit = 100,
  random = FALSE,
  nram = 3,
  p00 = NULL
)
}
\arguments{
\item{X}{Model matrix, with nrow = num of design points and ncol = num of parameters}

\item{w}{Diagonal of W matrix in Fisher information matrix, can be calculated Xw_maineffects_self() function in the ForLion package}

\item{reltol}{The relative convergence tolerance, default value 1e-5}

\item{maxit}{The maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, if TRUE then the function will run with additional "nram" number of initial allocation p00, default to be TRUE}

\item{nram}{When random == TRUE, the function will generate nram number of initial points, default is 3}

\item{p00}{Specified initial design approximate allocation; default to be NULL, this will generate a random initial design}
}
\value{
p D-optimal approximate allocation

p0 Initial approximate allocation that derived the reported D-optimal approximate allocation

Maximum The maximum of the determinant of the Fisher information matrix of the reported D-optimla design

convergence Convergence TRUE or FALSE

itmax number of the iteration
}
\description{
Lift-one algorithm for D-optimal approximate design in log scale
}
\examples{
hfunc.temp = function(y) {c(y,y[4]*y[5],1);};   # y -> h(y)=(y1,y2,y3,y4,y5,y4*y5,1)
link.temp="logit"
x.temp = matrix(data=c(25.00000,1,-1,1,-1,25.00000,1,1,1,-1,32.06741,-1,1,-1,1,40.85698,
-1,1,1,-1,28.86602,-1,1,-1,-1,29.21486,-1,-1,1,1,25.00000,1,1,1,1, 25.00000,1,1,-1,-1),
ncol=5, byrow=TRUE)
b.temp = c(0.3197169,  1.9740922, -0.1191797, -0.2518067,  0.1970956,  0.3981632, -7.6648090)
X.mat = matrix(,nrow=8, ncol=7)
w.vec = rep(NA,8)
for(i in 1:8) {
htemp=Xw_maineffects_self(x=x.temp[i,], b=b.temp, link=link.temp, h.func=hfunc.temp);
X.mat[i,]=htemp$X;
w.vec[i]=htemp$w;
};
liftoneDoptimal_log_GLM_func(X=X.mat, w=w.vec, reltol=1e-5, maxit=500,
random=TRUE, nram=3, p00=NULL)
}
