% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctf_tools.R
\name{ctf_tools}
\alias{ctf_tools}
\title{Cross-temporal reconciliation tools}
\usage{
ctf_tools(C, m, h = 1, Ut, nb, sparse = TRUE)
}
\arguments{
\item{C}{(\mjseqn{n_a \times n_b}) cross-sectional (contemporaneous) matrix
mapping the bottom level series into the higher level ones.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of the \mjseqn{p} factors
of \mjseqn{m}.}

\item{h}{Forecast horizon for the lowest frequency (most temporally aggregated) time
series (\emph{default} is \code{1}).}

\item{Ut}{Zero constraints cross-sectional (contemporaneous) kernel matrix
\mjseqn{(\mathbf{U}'\mathbf{y} = \mathbf{0})} spanning the null space valid
for the reconciled forecasts. It can be used instead of parameter
\code{C}, but \code{nb} (\mjseqn{n = n_a + n_b}) is needed if
\mjseqn{\mathbf{U}' \neq [\mathbf{I} \ -\mathbf{C}]}{}. If the hierarchy
admits a structural representation, \mjseqn{\mathbf{U}'} has dimension
(\mjseqn{n_a \times n}).}

\item{nb}{Number of bottom time series; if \code{C} is present, \code{nb}
and \code{Ut} are not used.}

\item{sparse}{Option to return sparse object (\emph{default} is \code{TRUE}).}
}
\value{
\strong{ctf} list with:
\item{\code{Ht}}{Full row-rank cross-temporal zero constraints (kernel)
matrix coherent with \mjseqn{\mathbf{y} = \mbox{vec}(\mathbf{Y}')}: \mjseqn{\mathbf{H}'\mathbf{y} = \mathbf{0}}.}
\item{\code{Hbrevet}}{Complete, not full row-rank cross-temporal zero
constraints (kernel) matrix coherent with \mjseqn{\mathbf{y} = \mbox{vec}(\mathbf{Y}')}:
\mjseqn{\breve{\mathbf{H}}'\mathbf{y} = \mathbf{0}}.}
\item{\code{Hcheckt}}{Full row-rank cross-temporal zero constraints (kernel) matrix coherent with
\mjseqn{\check{\mathbf{y}}} (structural representation):
\mjseqn{\check{\mathbf{H}}' \check{\mathbf{y}} = \mathbf{0}}.}
\item{\code{Ccheck}}{Cross-temporal aggregation matrix \mjseqn{\check{\mathbf{C}}}
coherent with \mjseqn{\check{\mathbf{y}}} (structural representation).}
\item{\code{Scheck}}{Cross-temporal summing matrix \mjseqn{\check{\mathbf{S}}}
coherent with \mjseqn{\check{\mathbf{y}}} (structural representation).}
\item{\code{Fmat}}{Cross-temporal summing matrix \mjseqn{\widetilde{\mathbf{F}}}
coherent with \mjseqn{\mathbf{y} = \mbox{vec}(\mathbf{Y}')}.}

\strong{hts} list from \code{\link{hts_tools}} .

\strong{thf} list from \code{\link{thf_tools}} .
}
\description{
\loadmathjax
Some useful tools for the cross-temporal forecast reconciliation of a linearly constrained
(hierarchical/grouped) multiple time series.
}
\examples{
# One level hierarchy (na = 1, nb = 2) with quarterly data
obj <- ctf_tools(C = matrix(c(1, 1), 1), m = 4)

}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
\keyword{utilities}
