% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FoRDM-package.R
\docType{package}
\encoding{UTF-8}
\name{FoRDM}
\alias{FoRDM-package}
\alias{FoRDM}
\title{Forest Many-Objective Robust Decision Making (FoRDM)}
\description{
This package provides a toolkit for supporting robust forest management under deep uncertainty.
It provides a forestry-focused application of Many-Objective Robust Decision Making (MORDM) to forest simulation outputs,
enabling users to evaluate robustness using regret- and satisficing-based measures. FoRDM identifies robust solutions,
generates Pareto fronts, and offers interactive 2D, 3D, and parallel-coordinate visualizations.
}
\details{
Main features:
\itemize{
\item Create FoRDM input tables from forest simulation outputs.
\item Calculate robustness measures based on Regret and Satisficing approaches.
\item Visualize results using 2D, 3D, or parallel-coordinate plots.
\item Explore trade-offs between robustness and performance.
}
}
\seealso{
browseVignettes(package = "FoRDM")
}
\author{
Marc Djahangard \email{marc.djahangard@ife.uni-freiburg.de} (author, maintainer)

Rasoul Yousefpour (author)
}
