% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resume_inbreed.R
\name{resume_inbreed}
\alias{resume_inbreed}
\title{Calculate inbreeding coefficients from scratch or resume for new individuals in the pedigree}
\usage{
resume_inbreed(ped, f = c(), d = c(), export_d = FALSE)
}
\arguments{
\item{ped}{: A data frame with integer columns corresponding to ID, SIRE, and DAM. IDs should be sequential, starting from 1. Missing parents (SIRE and DAM) are denoted as 0.}

\item{f}{: (Optional) If available, the vector of inbreeding coefficients from the previous calculation of inbreeding coefficients with less number of animals in the pedigree.}

\item{d}{: (Optional) If available, the vector of the diagonal elements of the diagonal matrix \bold{D} in \eqn{\mathbf A = \mathbf{TDT}'}
from the previous calculation of inbreeding coefficients with less number of animals in the pedigree,
where \bold{A} is the numerator relationship matrix.}

\item{export_d}{: \code{FALSE} (default) or \code{TRUE}. If \code{TRUE}, vector \code{d} is retuned for future use.}
}
\value{
: Vector of inbreeding coefficients if \code{export_d == FALSE},
or a list containing the vector of inbreeding coefficients and the vector of \code{d} coefficients if \code{export_d == TRUE}.
}
\description{
Calculate inbreeding coefficients from scratch or resume for new individuals in the pedigree
}
\examples{
# A sample pedigree data frame:
ped <- data.frame(
    ID = 1:12,
    SIRE = c(0, 0, 0, 2, 2, 0, 4, 6, 0, 6, 10, 10),
    DAM = c(0, 0, 0, 1, 1, 0, 3, 5, 7, 8, 9, 0)
)

oldped <- ped[1:9, ]
(oldrun <- resume_inbreed(oldped, export_d = TRUE))
resume_inbreed(ped)
resume_inbreed(ped, f = oldrun$f)
resume_inbreed(ped, f = oldrun$f, d = oldrun$d)

}
