% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trajectories.R
\name{plot_trajectories}
\alias{plot_trajectories}
\title{Barplot of birds counts par site and per time step, given bird trajectories.}
\usage{
plot_trajectories(migr, traj)
}
\arguments{
\item{migr}{A migration structure.}

\item{traj}{A trajectory matrix with a trajectory for each bird, matrix N x (horizon+1).}
}
\value{
Barplot of birds counts and return a count matrix (S+2) x (horizon+1)
with, at each time step (0,...,horizon), specify the number of bird on each site (rows 1,...,S),
flying (row S+1) and dead (row S+2).
}
\description{
Barplot of birds counts par site and per time step, given bird trajectories.
}
\examples{
migr <- generate_toy_migration()
traj <- generate_trajectories( migr )
counts <- plot_trajectories( migr, traj )
}
