% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{estimate_mus}
\alias{estimate_mus}
\title{Estimate the fluctuating mean sequence via maximum likelihood}
\usage{
estimate_mus(data, Sig_eta, Sig_nu, Phi, Sig_e1)
}
\arguments{
\item{data}{Numeric matrix of dimension \eqn{n \times p}, representing
the observed time series \eqn{\{\mathbf{y}_t\}_{t=1}^n}.}

\item{Sig_eta}{Numeric \eqn{p \times p} matrix
\eqn{\Sigma_{\boldsymbol{\eta}}}, covariance of the random walk
innovation.}

\item{Sig_nu}{Numeric \eqn{p \times p} matrix
\eqn{\Sigma_{\boldsymbol{\nu}}}, covariance of the VAR(1) innovation.}

\item{Phi}{Numeric \eqn{p \times p} autoregressive coefficient matrix
\eqn{\Phi}.}

\item{Sig_e1}{Numeric \eqn{p \times p} initial-state covariance matrix
\eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}.}
}
\value{
A numeric matrix of dimension \eqn{n \times p}, containing the estimated
fluctuating mean vectors \eqn{\hat{\boldsymbol{\mu}}_t}.
}
\description{
Implements the maximum likelihood estimation (MLE) procedure for the
fluctuating mean sequence \eqn{\{\boldsymbol{\mu}_t\}_{t=1}^n} in the
proposed model, given the parameters (or their estimates)
\eqn{\Sigma_{\boldsymbol{\eta}}}, \eqn{\Sigma_{\boldsymbol{\nu}}},
\eqn{\Phi}, and \eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}.
}
\details{
The algorithm performs forward and backward recursions to compute
the MLE of \eqn{\boldsymbol{\mu}_t} under the proposed model with Gaussian noises:
\deqn{\mathbf{y}_t = \boldsymbol{\mu}_t + \boldsymbol{\epsilon}_t, \quad
        \boldsymbol{\mu}_t = \boldsymbol{\mu}_{t-1} + \boldsymbol{\eta}_t, \quad
        \boldsymbol{\epsilon}_t = \Phi \boldsymbol{\epsilon}_{t-1} + \boldsymbol{\nu}_t.}

This estimation provides the smoothed mean trajectory that captures
gradual fluctuations between change points, conditioned on the given
model parameters.
}
\keyword{internal}
