% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgen.R
\name{rVIB}
\alias{rVIB}
\title{Random generation from the variance-inflated beta distribution}
\usage{
rVIB(n, mu, phi, p, k)
}
\arguments{
\item{n}{the number of observations. If \code{length(n)} > 1, the length is taken to be the number required.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a positive real value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{k}{the extent of the variance inflation. It must lie in (0, 1).}
}
\value{
A vector of length  \code{n}.
}
\description{
The function randomly generates values from the variance-inflated beta distribution.
}
\examples{
rVIB(100,0.5,30,0.3,0.6)

}
\references{
{
 Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020) Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309. doi:10.1177/1471082X18821213
}
}
