% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{dVIB}
\alias{dVIB}
\title{Variance-inflated beta probability density function}
\usage{
dVIB(x, mu, phi, p, k)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a positive real value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{k}{the extent of the variance inflation. It must lie in (0, 1).}
}
\value{
A vector with the same length as \code{x}.
}
\description{
The function computes the probability density function of the variance-inflated beta distribution.
}
\details{
The VIB distribution is a special mixture of two beta distributions
\deqn{p Beta(x|\mu,\phi k)+(1-p)Beta(x|\mu,\phi)}
 for \eqn{0<x<1} where \eqn{Beta(x|\cdot,\cdot)} is the beta distribution with a mean-precision parameterization.
 Moreover, \eqn{0<p<1} is the mixing weight, \eqn{0<\mu<1} represents the overall (as well as mixture component)
 mean, \eqn{\phi>0} is a precision parameter, and \eqn{0<k<1} determines the extent of the variance inflation.
}
\examples{
dVIB(x = c(.5,.7,.8), mu = 0.3, phi = 20, p = .5, k= .5)

}
\references{
{
Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020) Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309.
doi:10.1177/1471082X18821213
}
}
