% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_instruments_by.R
\name{ls_instruments_by}
\alias{ls_instruments_by}
\title{Subset names of instruments}
\usage{
ls_instruments_by(what, value, in.slot = NULL, pattern = NULL,
  match = TRUE)
}
\arguments{
\item{what}{What attribute? (e.g. \dQuote{currency}, \dQuote{type}, 
\dQuote{strike}, etc.)}

\item{value}{What value must the attribute have? (e.g. \dQuote{EUR},
\dQuote{option}, 100, etc.).  If missing or \code{NULL}, the names of all
  instruments that have a \code{what} slot will be returned}

\item{in.slot}{If the attribute you are looking for is stored inside another
slot, this is the name of that slot. (usually "IB")}

\item{pattern}{only return instruments with \code{pattern} in the name}

\item{match}{should pattern match names exactly?}
}
\value{
chr vector of instrument names
}
\description{
list names of instruments that have an attribute that matches some value
}
\details{
list instruments that have a given attribute level with a given value.
}
\examples{

\dontrun{
stock(c("GOOG","INTC"),currency("USD"))
synthetic("SnP","USD",src=list(name='^GSPC',src='yahoo'))
ls_instruments_by('type','stock')
ls_instruments_by("name",NULL,in.slot='src')
ls_instruments_by('src',NULL)
}
}
\seealso{
buildHierarchy, instrument.table, ls_instruments
}
\author{
Garrett See
}
