##' @title Get ggplot2 Grapic observed versus estimated
##' @description this function displays/saves/returns a Graphical ggplot2 illustrating the difference between the observed and estimated
##' @param titulo is the title graphic
##' @param nome name of file case save
##' @param observado list containing the observations of variable
##' @param estimado list containing estimates of variable
##' @param identificadorIndividual list containing 'id' of individuals
##' @param identificadorGrupal list containing group of individuals
##' @param showTestF draw results of test F in graphic?
##' @param TestFposition show one of the four corners of the graph clockwise
##' @param titleIdentificadorGrupal title of Legend of the groups
##' @param save If you want to save enter the directory as a string
##' @param labsX label x
##' @param labsy label y
##' @param nomeParaExibir This is the name to display the graph as a function after the completion of this
##' @param environ environment in which the function to display the ggplot2 must be saved
##' @param extensao type of image that will be saved
##' @param ... only for compatibility with other functions
##' @return will be returned the graphical generated by ggplot2
##' @import ggplot2
##' @export
getggplot2GraphicObservadoXEstimado <- function(titulo="observadoXestimado", nome ="observadoXestimado",  observado, estimado, identificadorIndividual = NULL, identificadorGrupal = NULL, showTestF = TRUE, TestFposition = 4, titleIdentificadorGrupal = NULL, save=NULL, labsX = "observado",  labsy = "estimado", nomeParaExibir = NULL, environ = 1, extensao = ".png", ...){
  graphic = ggplot(data = NULL, aes(observado, estimado))

  if(!is.null(identificadorIndividual) && !is.null(identificadorGrupal ))
  {graphic <- ggplot(data = NULL, aes(observado, estimado, colour = as.factor(identificadorIndividual), size = unclass(as.factor(identificadorGrupal))))}
  else if (!is.null(identificadorIndividual))
  {graphic <- ggplot(data = NULL, aes(observado, estimado, colour = as.factor(identificadorIndividual)))}
  else if (!is.null(identificadorGrupal ))
  {graphic <- ggplot(data = NULL, aes(observado, estimado, colour = as.factor(identificadorGrupal)))}

  graphic = graphic + guides(color = FALSE)  +  geom_point() + geom_abline() + stat_smooth(fill="blue", colour="darkblue", size=2) + labs(x = labsX,  y = labsy, title  = titulo)

  if (is.null(titleIdentificadorGrupal))
    graphic = graphic + guides(size = FALSE)
  else
    graphic = graphic + labs(size = titleIdentificadorGrupal)

  if (showTestF == TRUE)
  {

    coeficientes = lm(estimado ~ observado)

    #pos 4 top left
    X = min(observado)
    Y = max(estimado)
    hj = 0
    vj = 1
    if (TestFposition == 1)
    {
      #pos 1 top right
      X = max(observado)
      Y = max(estimado)
      hj = 1
      vj = 1
    }
    if (TestFposition == 2)
    {
      #pos 2 botton right
      X = max(observado)
      Y = min(estimado)
      hj = 1
      vj = 0
    }
    if (TestFposition == 3)
    {
      #pos 3 botton left
      X = min(observado)
      Y = min(estimado)
      hj = 0
      vj = 0
    }

    graphic = graphic  + annotate("text", colour = "black", x=X, y=Y, label = paste("atop( bold(Teste~~paste(F,':')), atop(paste(beta,0) == ", coeficientes$coefficients[1], ", paste(beta,1) == ", coeficientes$coefficients[2], "))"), parse = T, hjust = hj, vjust = vj)
  }

  if (!is.null(save))
  {
    ggsave(paste0(save, nome, extensao), plot = graphic)
  }

  if (!is.null(nomeParaExibir)){
    eval(parse(text = paste0("assign(\"", nomeParaExibir, "\", graphic, envir = as.environment(environ))")))
    print(paste0("use ", nomeParaExibir, " para exibir o ggplot2"))
    #eval(parse(text =  paste0("print(\"", "use ", exibir, " para exibir o ggplot2", "\")")), envir = as.environment(environ))
  }

  return (graphic)
}
