% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PADUS_FUNCTIONS.R
\name{get_padus}
\alias{get_padus}
\title{Download and crop the PAD-US Dataset.}
\usage{
get_padus(
  template,
  label,
  layer = c("Manager_Name"),
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "padus", label),
  force.redo = FALSE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{SpatRaster}} object to serve as a template for cropping.
Optionally, a vector of unit names, e.g., \code{c('Mesa Verde National Park','Ute Mountain Reservation')} may be provided.}

\item{label}{A character string naming the study area.}

\item{layer}{A character vector containing one or more PAD-US Layers.
By default, the \strong{Manager_Name} layer is downloaded.
\itemize{
\item \strong{Protection_Status_by_GAP_Status_Code}: \href{https://usgs.maps.arcgis.com/home/item.html?id=b7a09e6c95a846fe82970c70195a2739}{PAD-US 3.0 Protection Status by GAP Status Code} — Service representing a measure of management intent to permanently protect biodiversity. GAP 1&2 areas are primarily managed for biodiversity, GAP 3 are managed for multiple uses including conservation and extraction, GAP 4 no known mandate for biodiversity protection. GAP Status Codes 1-3 are displayed, GAP 4 areas included but not displayed.
\item \strong{Public_Access}: \href{https://usgs.maps.arcgis.com/home/item.html?id=3687ff551d7e4f0992f08419c2b29dd5}{PAD-US 3.0 Public Access} — Service representing general level of public access permitted in the area - Open, Restricted (permit, seasonal), Closed. Public Access Unknown areas not displayed. Use to show general categories of public access (however, not all areas have been locally reviewed).
\item \strong{Fee_Manager}: \href{https://usgs.maps.arcgis.com/home/item.html?id=0739a72a622443c98253d766c5416fc5}{PAD-US 3.0 Fee Manager} — Manager or administrative agency names standardized nationally. Use for categorization by manager name, with detailed federal managers and generic state/local/other managers. Where available this layer includes fee simple parcels from the Fee feature class plus DOD and Tribal areas from the Proclamation feature class.
\item \strong{Manager_Name}: \href{https://usgs.maps.arcgis.com/home/item.html?id=ff6f75a7f4b148cb97e9d755299edded}{PAD-US 3.0 Manager Name} — Service representing coarse level land manager description from "Agency Type" Domain, "Manager Type" Field (for example, Federal, Tribal, State, Local Gov, Private). Use for broad categorization of manager levels, for general depictions of who manages what areas.
\item \strong{Manager_Type}: \href{https://usgs.maps.arcgis.com/home/item.html?id=f0c68c83c88a46dcbb80fd33780ee9f5}{PAD-US 3.0 Manager Type} — Service representing coarse level land manager description from "Agency Type" Domain, "Manager Type" Field (for example, Federal, Tribal, State, Local Gov, Private). Use for broad categorization of manager levels, for general depictions of who manages what areas.
\item \strong{Federal_Fee_Managers_Authoritative}: \href{https://usgs.maps.arcgis.com/home/item.html?id=3fb354192e92407b9b86979669c47e4c}{PAD-US 3.0 Federal Fee Managers Authoritative} — An ArcGIS WebService describing authoritative fee data for federal managers or administrative agencies by name. U.S. Department of Defense and Tribal areas shown from the Proclamation feature class. Use to depict authoritative fee data for individual federal management agencies (no state, local or private lands). This service does not include designations that often overlap state, private or other inholdings. U.S. Department of Defense internal land ownership is not represented but is implied Federal. See the Federal Management Agencies service for a combined view of fee ownership, designations, and easements.
\item \strong{Federal_Management_Agencies}: \href{https://usgs.maps.arcgis.com/home/item.html?id=562afaf9385a45598f919739bac474e9}{PAD-US 3.0 Federal Management Agencies} — Federal managers or administrative agencies by name. Use to depict individual federal management agencies (no state, local or private lands). This map is based on the Combined Proclamation, Marine, Fee, Designation, Easement feature class.
\item \strong{Protection_Mechanism_Category}: \href{https://usgs.maps.arcgis.com/home/item.html?id=22670023fd124c799d5ddd08297dde85}{PAD-US 3.0 Protection Mechanism Category} — Service representing the protection mechanism category including fee simple, internal management designations, easements, leases and agreements, and Marine Areas. Use to show categories of land tenure for all protected areas, including marine areas.
\item \strong{Proclamation_and_Other_Planning_Boundaries}: \href{https://usgs.maps.arcgis.com/home/item.html?id=960df4c1bb7849809b82e185dffe9cdb}{PAD-US 3.0 Proclamation and Other Planning Boundaries} — Service representing boundaries that provide additional context. Administrative agency name standardized for the nation (DOD, FWS, NPS, USFS, Tribal). Boundaries shown with outline only, as proclamation data do not depict actual ownership or management. Use to show outline of agency proclamation, approved acquisition or other planning boundaries where internal ownership is not depicted.
\item \strong{Fee_Topology_Overlaps}: \href{https://usgs.maps.arcgis.com/home/item.html?id=b8068025827b4aa0866955fd9ae38321}{PAD-US 3.0 Topology Overlaps} — Topology assessment of the Fee feature class. Use to identify overlaps in Fee data between Federal agencies and between Federal/State lands.
}}

\item{extraction.dir}{A character string indicating where the extracted and cropped PAD-US data should be put.}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A list of \link[sf:sf]{sf::sf} collections extracted from the PAD-US Dataset.
}
\description{
\code{get_padus} returns a list of \code{sf} objects extracted
from the PAD-US Dataset. Data are retrieved directly from
\href{https://www.usgs.gov/programs/gap-analysis-project/science/pad-us-web-services}{PAD-US ArcGIS Web Services}.
}
\details{
\href{https://www.usgs.gov/programs/gap-analysis-project/science/pad-us-data-overview}{PAD-US} is America’s official national inventory of U.S. terrestrial and
marine protected areas that are dedicated to the preservation of biological
diversity and to other natural, recreation and cultural uses, managed for
these purposes through legal or other effective means. PAD-US also includes
the best available aggregation of federal land and marine areas provided
directly by managing agencies, coordinated through the Federal Geographic
Data Committee Federal Lands Working Group.
}
\examples{
\dontrun{
# Get the PAD-US (USA ONLY)
PADUS <- get_padus(
  template = FedData::meve,
  label = "meve"
)
PADUS
}
}
