% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DetailedCovariateSettings.R
\name{createDetailedTemporalCovariateSettings}
\alias{createDetailedTemporalCovariateSettings}
\title{Create detailed temporal covariate settings}
\usage{
createDetailedTemporalCovariateSettings(
  analyses = list(),
  temporalStartDays = -365:-1,
  temporalEndDays = -365:-1
)
}
\arguments{
\item{analyses}{A list of analysis detail objects as created using
\code{\link{createAnalysisDetails}}.}

\item{temporalStartDays}{A list of integers representing the start of a time period, relative to
the index date. 0 indicates the index date, -1 indicates the day before
the index date, etc. The start day is included in the time period.}

\item{temporalEndDays}{A list of integers representing the end of a time period, relative to the
index date. 0 indicates the index date, -1 indicates the day before the
index date, etc. The end day is included in the time period.}
}
\value{
An object of type \code{covariateSettings}, to be used in other functions.
}
\description{
Create detailed temporal covariate settings
}
\details{
creates an object specifying in detail how temporal covariates should be constructed from data in
the CDM model. Warning: this function is for advanced users only.
}
\examples{
\donttest{
analysisDetails <- createAnalysisDetails(
  analysisId = 1,
  sqlFileName = "DemographicsGender.sql",
  parameters = list(
    analysisId = 1,
    analysisName = "Gender",
    domainId = "Demographics"
  ),
  includedCovariateConceptIds = c(),
  addDescendantsToInclude = FALSE,
  excludedCovariateConceptIds = c(),
  addDescendantsToExclude = FALSE,
  includedCovariateIds = c()
)
covSettings <- createDetailedTemporalCovariateSettings(
  analyses = analysisDetails,
  temporalStartDays = -365:-1,
  temporalEndDays = -365:-1
)
}

}
