/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.featureExtraction;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ohdsi.featureExtraction.ReadCSVFile;
import org.ohdsi.featureExtraction.Row;

public class ReadCSVFileWithHeader
implements Iterable<Row> {
    private InputStream inputstream;
    private char delimiter = (char)44;

    public ReadCSVFileWithHeader(String filename, char delimiter) {
        this(filename);
        this.delimiter = delimiter;
    }

    public ReadCSVFileWithHeader(String filename) {
        try {
            this.inputstream = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public ReadCSVFileWithHeader(InputStream inputstream) {
        this.inputstream = inputstream;
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowIterator();
    }

    public class RowIterator
    implements Iterator<Row> {
        private Iterator<List<String>> iterator;
        private Map<String, Integer> fieldName2ColumnIndex;

        public RowIterator() {
            this.iterator = new ReadCSVFile(ReadCSVFileWithHeader.this.inputstream, ReadCSVFileWithHeader.this.delimiter).iterator();
            this.fieldName2ColumnIndex = new HashMap<String, Integer>();
            for (String header : this.iterator.next()) {
                this.fieldName2ColumnIndex.put(header, this.fieldName2ColumnIndex.size());
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Row next() {
            return new Row(this.iterator.next(), this.fieldName2ColumnIndex);
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported");
        }
    }
}

