/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.ohdsi.sql.SqlSplit;
import org.ohdsi.sql.SqlTranslate;
import org.ohdsi.sql.StringUtils;

public class BigQuerySparkTranslate {
    private static String bigQueryAliasCommonTableExpressions(String sql, String pattern) {
        List<SqlTranslate.Block> cte_pattern = SqlTranslate.parseSearchPattern(pattern);
        SqlTranslate.MatchedPattern cte_match = SqlTranslate.search(sql, cte_pattern, 0);
        while (cte_match.start != -1) {
            CommaListIterator with_list_iter = new CommaListIterator(cte_match.variableToValue.get("@@b"), CommaListIterator.ListType.WITH_COLUMNS);
            CommaListIterator select_list_iter = new CommaListIterator(cte_match.variableToValue.get("@@c"), CommaListIterator.ListType.SELECT);
            String replacement_select_list = "";
            while (!with_list_iter.IsDone() && !select_list_iter.IsDone()) {
                String with_expr = with_list_iter.GetFullExpression();
                String select_expr = select_list_iter.GetExpressionPrefix() + " as " + with_expr;
                if (replacement_select_list.length() > 0) {
                    replacement_select_list = replacement_select_list + ",";
                }
                replacement_select_list = replacement_select_list + select_expr;
                with_list_iter.Next();
                select_list_iter.Next();
            }
            replacement_select_list = select_list_iter.GetListPrefix() + replacement_select_list + select_list_iter.GetListSuffix();
            sql = sql.substring(0, cte_match.start) + pattern.replace("@@a", cte_match.variableToValue.get("@@a")).replace("(@@b)", "").replace("@@c", replacement_select_list).replace("@@d", BigQuerySparkTranslate.nullToEmptyString(cte_match.variableToValue.get("@@d"))) + sql.substring(cte_match.end);
            cte_match = SqlTranslate.search(sql, cte_pattern, cte_match.startToken + 1);
        }
        return sql;
    }

    private static String nullToEmptyString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String bigQueryConvertSelectListReferences(String sql, String select_pattern, CommaListIterator.ListType list_type) {
        List<SqlTranslate.Block> select_statement_pattern = SqlTranslate.parseSearchPattern(select_pattern);
        SqlTranslate.MatchedPattern select_statement_match = SqlTranslate.search(sql, select_statement_pattern, 0);
        while (select_statement_match.start != -1) {
            String select_list = select_statement_match.variableToValue.get("@@s");
            String list_to_replace = select_statement_match.variableToValue.get("@@r");
            String replacement_list = "";
            CommaListIterator list_to_replace_iter = new CommaListIterator(list_to_replace, list_type);
            while (!list_to_replace_iter.IsDone()) {
                String list_expr = list_to_replace_iter.GetExpressionPrefix();
                String list_expr_suffix = list_to_replace_iter.GetExpressionSuffix();
                List<SqlTranslate.Block> list_expr_pattern = SqlTranslate.parseSearchPattern(list_expr);
                if (list_to_replace_iter.IsSingleColumnReference()) {
                    replacement_list = replacement_list + ", " + list_expr + list_expr_suffix;
                } else {
                    CommaListIterator select_list_iter = new CommaListIterator(select_list, CommaListIterator.ListType.SELECT);
                    boolean found = false;
                    int i = 1;
                    while (!select_list_iter.IsDone()) {
                        String select_expr = select_list_iter.GetExpressionPrefix();
                        if (SqlTranslate.search((String)select_expr, list_expr_pattern, (int)0).start != -1) {
                            found = true;
                            replacement_list = replacement_list + ", " + i + list_expr_suffix;
                            break;
                        }
                        ++i;
                        select_list_iter.Next();
                    }
                    if (!found) {
                        replacement_list = replacement_list + ", " + list_expr + list_expr_suffix;
                    }
                }
                list_to_replace_iter.Next();
            }
            replacement_list = list_to_replace_iter.GetListPrefix() + replacement_list.substring(1) + list_to_replace_iter.GetListSuffix();
            String suffix = sql.substring(select_statement_match.end);
            sql = sql.substring(0, select_statement_match.start);
            for (int i = 0; i < select_statement_pattern.size(); ++i) {
                if (sql.length() > 0) {
                    sql = sql + " ";
                }
                SqlTranslate.Block block = select_statement_pattern.get(i);
                if (block.isVariable) {
                    if (block.text.equals("@@r")) {
                        sql = sql + replacement_list;
                        continue;
                    }
                    sql = sql + select_statement_match.variableToValue.get(block.text);
                    continue;
                }
                sql = sql + block.text;
            }
            sql = sql + suffix;
            select_statement_match = SqlTranslate.search(sql, select_statement_pattern, select_statement_match.startToken + 1);
        }
        return sql;
    }

    private static String bigQueryLowerCase(String sql) {
        List<StringUtils.Token> tokens = StringUtils.tokenizeSql(sql);
        for (StringUtils.Token token : tokens) {
            if (token.inQuotes || token.text.startsWith("@")) continue;
            sql = sql.substring(0, token.start) + token.text.toLowerCase() + sql.substring(token.end);
        }
        return sql;
    }

    public static String translatebigQuery(String sql) {
        sql = BigQuerySparkTranslate.bigQueryLowerCase(sql);
        sql = BigQuerySparkTranslate.bigQueryAliasCommonTableExpressions(sql, "with @@a (@@b) as (select @@c from @@d)");
        sql = BigQuerySparkTranslate.bigQueryAliasCommonTableExpressions(sql, "with @@a (@@b) as (select @@c union @@d)");
        sql = BigQuerySparkTranslate.bigQueryAliasCommonTableExpressions(sql, "with @@a (@@b) as (select @@c)");
        sql = BigQuerySparkTranslate.bigQueryAliasCommonTableExpressions(sql, ", @@a (@@b) as (select @@c from @@d)");
        String groupByReferences = "select @@s from @@b group by @@r";
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, groupByReferences + ";", CommaListIterator.ListType.GROUP_BY);
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, groupByReferences + ")", CommaListIterator.ListType.GROUP_BY);
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, groupByReferences + " having", CommaListIterator.ListType.GROUP_BY);
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, groupByReferences + " order by", CommaListIterator.ListType.GROUP_BY);
        String orderBy = "select @@s from @@b order by @@r";
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, orderBy + ";", CommaListIterator.ListType.ORDER_BY);
        sql = BigQuerySparkTranslate.bigQueryConvertSelectListReferences(sql, orderBy + ")", CommaListIterator.ListType.ORDER_BY);
        return sql;
    }

    private static List<String> getMetaFields(String target_table_name, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet rs = statement.executeQuery("show columns in " + target_table_name);
        ArrayList<String> metaFields = new ArrayList<String>();
        while (rs.next()) {
            metaFields.add(rs.getString("COL_NAME").toLowerCase());
        }
        return metaFields;
    }

    private static String sparkCreateTable(String sql) {
        if (!sql.endsWith(";")) {
            sql = sql + ";";
        }
        String pattern = "CREATE TABLE @@table (@@definition)";
        List<SqlTranslate.Block> create_table_pattern = SqlTranslate.parseSearchPattern(pattern);
        sql = sql.trim().replaceAll("\t", " ").replaceAll(" +", " ");
        SqlTranslate.MatchedPattern create_table_match = SqlTranslate.search(sql, create_table_pattern, 0);
        String table_name = create_table_match.variableToValue.get("@@table");
        String definition_list = create_table_match.variableToValue.get("@@definition");
        if (table_name != null && definition_list != null) {
            table_name = table_name.replaceAll("\r\n", "");
            definition_list = definition_list.toLowerCase().replaceAll("\r\n", "").replaceAll(" as ", " ");
            ArrayList<String> column_names = new ArrayList<String>();
            for (String f : definition_list.split(",")) {
                column_names.add("\tCAST(NULL AS " + f.trim().split(" ")[1] + ") AS " + f.trim().split(" ")[0]);
            }
            String prefix = sql.substring(0, create_table_match.start);
            sql = prefix + "SELECT " + String.join((CharSequence)",\r\n", column_names) + " INTO " + table_name + " WHERE 1 = 0";
        }
        return sql.replaceAll(";", "");
    }

    private static String sparkInsertGetValueMappings(SqlTranslate.MatchedPattern insert_match, List<String> metaFields) {
        CommaListIterator insert_list_iter = new CommaListIterator(insert_match.variableToValue.get("@@columns"), CommaListIterator.ListType.WITH_COLUMNS);
        CommaListIterator select_list_iter = new CommaListIterator(insert_match.variableToValue.get("@@remainder"), CommaListIterator.ListType.SELECT);
        HashMap<String, String> mappings = new HashMap<String, String>();
        while (!insert_list_iter.IsDone() && !select_list_iter.IsDone()) {
            String column_expr = insert_list_iter.GetFullExpression().toLowerCase();
            String select_expr = select_list_iter.GetExpressionPrefix();
            mappings.put(column_expr.trim(), select_expr.trim());
            insert_list_iter.Next();
            select_list_iter.Next();
        }
        ArrayList<Object> definition_sql = new ArrayList<Object>();
        for (String mf : metaFields) {
            if (mappings.containsKey(mf)) {
                definition_sql.add(mappings.get(mf));
                continue;
            }
            definition_sql.add("NULL");
        }
        String all_select_sql = String.join((CharSequence)",\r\n", definition_sql);
        return all_select_sql;
    }

    private static String sparkInsertGetSelectMappings(List<String> metaFields, SqlTranslate.MatchedPattern insert_match) {
        CommaListIterator insert_list_iter = new CommaListIterator(insert_match.variableToValue.get("@@columns"), CommaListIterator.ListType.WITH_COLUMNS);
        ArrayList<String> column_names = new ArrayList<String>();
        while (!insert_list_iter.IsDone()) {
            String column_expr = insert_list_iter.GetFullExpression().toLowerCase();
            column_names.add(column_expr.trim());
            insert_list_iter.Next();
        }
        ArrayList definition_sql = new ArrayList();
        for (String mf : metaFields) {
            if (column_names.contains(mf)) {
                definition_sql.add(column_names.get(column_names.indexOf(mf)));
                continue;
            }
            definition_sql.add("NULL AS " + mf);
        }
        return String.join((CharSequence)",\r\n", definition_sql);
    }

    public static String sparkHandleInsert(String sql, String connectionString) throws SQLException {
        Connection connection = DriverManager.getConnection(connectionString);
        return BigQuerySparkTranslate.sparkHandleInsert(sql, connection);
    }

    public static String sparkHandleInsert(String sql, Connection connection) throws SQLException {
        ArrayList<String> splits = new ArrayList<String>(Arrays.asList(SqlSplit.splitSql(sql)));
        for (int i = 0; i < splits.size(); ++i) {
            splits.set(i, BigQuerySparkTranslate.sparkInsert((String)splits.get(i), connection));
        }
        splits.removeAll(Arrays.asList("", null));
        sql = splits.size() > 1 || sql.trim().endsWith(";") ? String.join((CharSequence)";\r\n", splits).trim() + ";" : String.join((CharSequence)";\r\n", splits).trim();
        return sql;
    }

    private static String sparkInsert(String sql, Connection connection) throws SQLException {
        if (!(sql = sql.trim().replaceAll("\t", " ").replaceAll(" +", " ")).trim().endsWith(";")) {
            sql = sql + ";";
        }
        String this_pattern = "INSERT INTO @@target (@@columns) VALUES (@@remainder);";
        List<SqlTranslate.Block> insert_pattern = SqlTranslate.parseSearchPattern(this_pattern);
        SqlTranslate.MatchedPattern insert_match = SqlTranslate.search(sql, insert_pattern, 0);
        String target_table = insert_match.variableToValue.get("@@target");
        String columns = insert_match.variableToValue.get("@@columns");
        String remainder = insert_match.variableToValue.get("@@remainder");
        if (target_table != null && columns != null && remainder != null) {
            List<String> metaFields;
            target_table = target_table.replaceAll("\r\n", "");
            try {
                metaFields = BigQuerySparkTranslate.getMetaFields(target_table, connection);
            }
            catch (SQLException e) {
                return sql;
            }
            String mappings = BigQuerySparkTranslate.sparkInsertGetValueMappings(insert_match, metaFields);
            sql = "INSERT INTO " + target_table + "\r\nVALUES\r\n(" + mappings + ")";
            return sql.replaceAll(";", "");
        }
        this_pattern = "INSERT INTO @@target (@@columns) @@remainder;";
        insert_pattern = SqlTranslate.parseSearchPattern(this_pattern);
        insert_match = SqlTranslate.search(sql, insert_pattern, 0);
        target_table = insert_match.variableToValue.get("@@target");
        remainder = insert_match.variableToValue.get("@@remainder");
        columns = insert_match.variableToValue.get("@@columns");
        if (target_table != null && remainder != null && columns != null) {
            List<String> metaFields;
            try {
                metaFields = BigQuerySparkTranslate.getMetaFields(target_table, connection);
            }
            catch (SQLException e) {
                return sql;
            }
            String mappings = BigQuerySparkTranslate.sparkInsertGetSelectMappings(metaFields, insert_match);
            sql = "with cte_wrapper (" + columns + ")\r\n as \r\n (\r\n" + remainder + "\r\n) \r\nINSERT INTO " + target_table + "\r\n select " + mappings + "\r\nfrom cte_wrapper";
        }
        return sql.replaceAll(";", "");
    }

    public static String translateSpark(String sql) {
        CharSequence[] splits = SqlSplit.splitSql(sql);
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = BigQuerySparkTranslate.sparkCreateTable(splits[i]);
        }
        sql = splits.length > 1 || sql.trim().endsWith(";") ? String.join((CharSequence)";\r\n", splits).trim() + ";" : String.join((CharSequence)";\r\n", splits).trim();
        return sql;
    }

    private static class CommaListIterator {
        private String expressionList;
        private List<SqlTranslate.Block> listElementPattern;
        private SqlTranslate.MatchedPattern currentMatch;
        private ListType listType;
        private String expressionPrefix;
        private String expressionSuffix;
        private String listPrefix;
        private String listSuffix;

        public CommaListIterator(String expression_list, ListType list_type) {
            this.listType = list_type;
            this.expressionList = expression_list;
            this.splitList();
            this.expressionList = "," + this.expressionList + ",";
            this.listElementPattern = SqlTranslate.parseSearchPattern(", @@a ,");
            this.currentMatch = SqlTranslate.search(this.expressionList, this.listElementPattern, 0);
            if (this.currentMatch.start != -1) {
                this.splitExpression();
            }
        }

        public boolean IsDone() {
            return this.currentMatch.start == -1;
        }

        public void Next() {
            int expr_length = StringUtils.tokenizeSql(this.expressionList.substring(this.currentMatch.start, this.currentMatch.end)).size();
            int startToken = this.currentMatch.startToken + expr_length - 1;
            this.currentMatch = SqlTranslate.search(this.expressionList, this.listElementPattern, startToken);
            if (this.currentMatch.start != -1) {
                this.splitExpression();
            }
        }

        public String GetExpressionPrefix() {
            return this.expressionPrefix;
        }

        public String GetExpressionSuffix() {
            return this.expressionSuffix;
        }

        public String GetFullExpression() {
            return this.expressionPrefix + this.expressionSuffix;
        }

        public String GetListPrefix() {
            return this.listPrefix;
        }

        public String GetListSuffix() {
            return this.listSuffix;
        }

        private void splitList() {
            this.listPrefix = "";
            this.listSuffix = "";
            switch (this.listType) {
                case SELECT: {
                    this.splitSelect();
                    break;
                }
                case GROUP_BY: {
                    this.splitGroupBy();
                    break;
                }
                case ORDER_BY: {
                    break;
                }
                case WITH_COLUMNS: {
                    break;
                }
            }
        }

        private void splitSelect() {
            SqlTranslate.MatchedPattern match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^ distinct @@a $"), 0);
            if (match.start != -1) {
                this.listPrefix = "distinct ";
                this.expressionList = match.variableToValue.get("@@a");
            }
            match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^@@a into @@b$"), 0);
            if (match.start != -1) {
                this.expressionList = match.variableToValue.get("@@a");
                this.listSuffix = " into " + match.variableToValue.get("@@b");
            }
        }

        private void splitGroupBy() {
            SqlTranslate.MatchedPattern match = SqlTranslate.search("^" + this.expressionList + "$", SqlTranslate.parseSearchPattern("^@@a order by @@b$"), 0);
            if (match.start != -1) {
                this.expressionList = match.variableToValue.get("@@a");
                this.listSuffix = " order by " + match.variableToValue.get("@@b");
            }
        }

        private void splitExpression() {
            this.expressionPrefix = this.currentMatch.variableToValue.get("@@a");
            this.expressionSuffix = "";
            switch (this.listType) {
                case SELECT: {
                    this.splitAlias();
                    break;
                }
                case GROUP_BY: {
                    break;
                }
                case ORDER_BY: {
                    this.splitOrderElement();
                    break;
                }
                case WITH_COLUMNS: {
                    break;
                }
            }
        }

        private void splitAlias() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.expressionPrefix);
            List<SqlTranslate.Block> alias_pattern = SqlTranslate.parseSearchPattern("^ @@a as @@b $");
            SqlTranslate.MatchedPattern alias_match = SqlTranslate.search("^" + this.expressionPrefix + "$", alias_pattern, 0);
            if (alias_match.start == -1) {
                if (tokens.size() >= 2) {
                    StringUtils.Token possible_alias = tokens.get(tokens.size() - 1);
                    String preceding_token = tokens.get((int)(tokens.size() - 2)).text;
                    if (possible_alias.isIdentifier() && !preceding_token.equalsIgnoreCase(".") && !preceding_token.equalsIgnoreCase("+")) {
                        this.expressionPrefix = this.expressionPrefix.substring(0, possible_alias.start);
                        this.expressionSuffix = possible_alias.text;
                    }
                }
            } else {
                this.expressionPrefix = alias_match.variableToValue.get("@@a");
                this.expressionSuffix = alias_match.variableToValue.get("@@b");
            }
        }

        private void splitOrderElement() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.GetFullExpression());
            StringUtils.Token last_token = tokens.get(tokens.size() - 1);
            if (last_token.text.equalsIgnoreCase("asc") || last_token.text.equalsIgnoreCase("desc")) {
                this.expressionPrefix = this.GetFullExpression().substring(0, last_token.start - 1);
                this.expressionSuffix = " " + last_token.text;
            }
        }

        public boolean IsSingleColumnReference() {
            List<StringUtils.Token> tokens = StringUtils.tokenizeSql(this.GetExpressionPrefix());
            return tokens.size() == 3 && tokens.get(0).isIdentifier() && tokens.get((int)1).text.contentEquals(".") && tokens.get(2).isIdentifier();
        }

        public static enum ListType {
            SELECT,
            GROUP_BY,
            ORDER_BY,
            WITH_COLUMNS,
            IN;

        }
    }
}

