% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FcircSEC.R
\name{circSeqExt}
\alias{circSeqExt}
\title{Generating full length circRNA sequences}
\usage{
circSeqExt(genomic_seq, circ_class_txt, out_filename)
}
\arguments{
\item{genomic_seq}{A fasta file (obtain using function \code{\link[FcircSEC]{get.fasta}}) with the genomic sequences for circRNAs}

\item{circ_class_txt}{The circRNA classification file (obtained from function \code{\link[FcircSEC]{circClassification}})}

\item{out_filename}{The name of the output file}
}
\value{
The fasta file containing the full length circRNA sequences will be written in the output file 'out_filename'
}
\description{
This function can extract the full length circRNA sequences from the output of the circular RNA predictions tools
}
\examples{

#Loading an example circRNA genomic sequence and write to a file
#Here temporary directory is created as input-output
#directory. Please provide you own directory instead.
out_dir<-tempdir()
circ_genomic_seq<-data("circRNA_genomic_sequence")
circ_genomic_seq<-circRNA_genomic_sequence
df.fasta=dataframe2fas(circ_genomic_seq, file.path(out_dir, "circ_genomic_seq.fasta"))

#Loading an example circ_class_txt data and write to a file
circ_class_txt<-data("circRNA_classt")
circ_class_txt<-circRNA_classt
write.table(circ_class_txt, file.path(out_dir, "circ_class.txt"), 
        row.names=FALSE)

#Extracting full length circRNA sequences. Here, the output will be 
#written in file circRNA_sequence.fasta in out_dir directory
circSeqExt(file.path(out_dir, "circ_genomic_seq.fasta"),
 file.path(out_dir, "circ_class.txt"), file.path(out_dir, "circRNA_sequence.fasta"))

}
