% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/e_conversion.R
\name{getnamesk}
\alias{getnamesk}
\title{Generate a list of vectors of characters from a vector of probabilities}
\usage{
getnamesk(probak = pprobs2)
}
\arguments{
\item{probak}{a vector of ordered probabilities with 0 and 1 excluded.}
}
\description{
Generate vector of characters from a vector of probabilities, replacing 
\code{0.} by letters:
\itemize{
  \item{ \code{p.} : probability. }
  \item{ \code{q.} : quantile. }
  \item{ \code{VaR.} : Value-at-Risk, positive in most cases. } 
  \item{ \code{c.} : corrective tail coefficient = (q - m) / (q_logistic_function - m). }
  \item{ \code{ltm.} : left tail mean (signed ES on the left tail, usually negative). } 
  \item{ \code{rtm.} : right tail mean (signed ES on the right tail, usually positive). }
  \item{ \code{dtmq.} : (p<=0.5 left, p>0.5 right) tail mean minus quantile. }
  \item{ \code{ES.} : expected shortfall, positive in most cases. }
  \item{ \code{h.} : corrective ES  = (ES - m) / (ES_logistic_function - m). }
  \item{ \code{desv.} : ES - VaR, usually positive. } 
  \item{ \code{l.} : quantile of the tangent logistic function. }
  \item{ \code{dl.} : quantile - quantile_logistic_function. }
  \item{ \code{g.} : quantile of the Laplace-Gauss function. } 
  \item{ \code{dg.} : quantile - quantile_Laplace_Gauss_function. }
}


, \code{q.}, \code{VaR.}, \code{c.}, \code{ltm.},
\code{rtm.}, \code{ES.}, \code{h.}, \code{l.}, \code{dl.}, \code{g.}, \code{dg.}.
The result is a list of vectors.
}
\examples{
    
getnamesk(pprobs1)
getnamesk(pprobs8)

}
\seealso{
Probabilities: \code{\link{pprobs0}}
}

