% Generated by roxygen2 (4.0.1): do not edit by hand
\name{kiener3}
\alias{dkiener3}
\alias{dlkiener3}
\alias{dpkiener3}
\alias{dqkiener3}
\alias{kiener3}
\alias{lkiener3}
\alias{pkiener3}
\alias{qkiener3}
\alias{qlkiener3}
\alias{rkiener3}
\title{Asymmetric Kiener Distribution (Type III)}
\usage{
dkiener3(x, m = 0, g = 1, k = 3.2, d = 0, log = FALSE)

pkiener3(q, m = 0, g = 1, k = 3.2, d = 0, lower.tail = TRUE,
  log.p = FALSE)

qkiener3(p, m = 0, g = 1, k = 3.2, d = 0, lower.tail = TRUE,
  log.p = FALSE)

rkiener3(n, m = 0, g = 1, k = 3.2, d = 0)

dpkiener3(p, m = 0, g = 1, k = 3.2, d = 0, log = FALSE)

dqkiener3(p, m = 0, g = 1, k = 3.2, d = 0, log = FALSE)

lkiener3(x, m = 0, g = 1, k = 3.2, d = 0)

dlkiener3(lp, m = 0, g = 1, k = 3.2, d = 0, log = FALSE)

qlkiener3(lp, m = 0, g = 1, k = 3.2, d = 0, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{q}{vector of quantiles.}

\item{m}{numeric. The median.}

\item{g}{numeric. The scale parameter, preferably strictly positive.}

\item{k}{numeric. The tail parameter, preferably strictly positive.}

\item{d}{numeric. The distorsion parameter between left and right tails.}

\item{p}{vector of probabilities.}

\item{lp}{vector of logit of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length is
taken to be the number required.}

\item{log}{logical; if TRUE, densities are given in log scale.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
                     P[X < x] otherwise, P[X > x].}
}
\description{
Density, distribution function, quantile function, random generation
and additional formulae for the Kiener distribution of type III.
}
\details{
Kiener distributions of type III are distributions with asymmetric left
and right fat tails described by a global tail parameter \code{k}
and a distorsion parameter \code{d}.

Distributions of type III (\code{\link{kiener3}})
with parameters \code{k} (kappa) and \code{d} (delta) and
distributions of type IV (\code{\link{kiener4}})
with parameters \code{k} (kappa) and \code{e} (epsilon))
have been created to disantangle the parameters
\code{a} (alpha) and \code{w} (omega) of distributions of
type II (\code{\link{kiener2}}).
The tiny difference between the types III and IV (\eqn{d = e/k})
has not yet been fully evaluated. Both should be tested at that moment.

\code{k} is the harmonic mean of \code{a} and \code{w} and represents a
global tail parameter.

\code{d} is a distorsion parameter between the left tail parameter
\code{a} and the right tail parameter \code{w}.
It verifies the inequality: \eqn{-k < d < k}
(whereas \code{e} of type IV verifies \eqn{-1 < e < 1}).
The conversion functions (see \code{\link{aw2k}}) are:

\deqn{1/k = (1/a + 1/w)/2 }
\deqn{  d = (-1/a + 1/w)/2 }
\deqn{1/a = 1/k - d }
\deqn{1/w = 1/k + d}

\code{d} (and \code{e}) should be of the same sign than the skewness.
A negative value \eqn{ d < 0 } implies \eqn{ a < w } and indicates a left
tail heavier than the right tail. A positive value \eqn{ d > 0 } implies
\eqn{ a > w } and a right tail heavier than the left tail.

\code{m} is the median of the distribution. \code{g} is the scale parameter
and the inverse of the density at the median: \eqn{ g = 1 / 8 / f(m) }.
As a first estimate, it is approximatively one fourth of the standard
deviation \eqn{ g  \approx \sigma / 4 } but is independant from it.

The d, p functions have no explicit forms. They are provided here for
convenience. They are estimated from a reverse optimization on the quantile
function and can be (very) slow, depending the number of points to estimate.
We recommand to use the quantile function as far as possible.
WARNING: Results may become inconsistent when \code{k} is
smaller than 1 or for very large absolute values of \code{d}.
Hopefully, this case seldom happens in finance.

\code{qkiener3} function is defined for p in (0, 1) by:
  \deqn{ qkiener3(p, m, g, k, d) =
              m + 2 * g * k * sinh(logit(p) / k) * exp(d * logit(p)) }

\code{rkiener3} generates \code{n} random quantiles.

In addition to the classical d, p, q, r functions, the prefixes
dp, dq, l, dl, ql are also provided.

\code{dpkiener3} is the density function calculated from the probability p.
The formula is adapted from type II. It is defined for p in (0, 1) by:
  \deqn{ dpkiener3(p, m, g, k, d) =
         p * (1 - p) / k / g / ( exp(-logit(p)/a)/a + exp(logit(p)/w)/w }
with \code{a} and \code{w} defined from \code{k} and \code{d}
with the formula presented above.

\code{dqkiener3} is the derivate of the quantile function calculated from
the probability p. The formula is adapted from type II.
It is defined for p in (0, 1) by:
  \deqn{ dqkiener3(p, m, g, k, d) =
         k * g / p / (1 - p) * ( exp(-logit(p)/a)/a + exp(logit(p)/w)/w ) }
with \code{a} and \code{w} defined above.

\code{lkiener3} function is estimated from a reverse optimization and can
be (very) slow depending the number of points to estimate. Initialization
is done with a symmetric distribution \code{\link{lkiener1}}
of parameter \code{k} (thus \eqn{ d = 0}). Then optimization is performed
to take into account the true value of \code{d}.
The results can then be compared to the empirical probability logit(p).
WARNING: Results may become inconsistent when \code{k} is
smaller than 1 or for very large absolute values of \code{d}.
Hopefully, this case seldom happens in finance.

\code{dlkiener3} is the density function calculated from the logit of the
probability lp = logit(p). The formula is adapted from type II.
it is defined for lp in (-Inf, +Inf) by:
   \deqn{ dlkiener3(lp, m, g, k, d) =
          p * (1 - p) / k / g / ( exp(-lp/a)/a + exp(lp/w)/w ) }
with \code{a} and \code{w} defined above.

\code{qlkiener3} is the quantile function calculated from the logit of the
probability. It is defined for lp in (-Inf, +Inf) by:
   \deqn{ qlkiener3(lp, m, g, k, d) =
          m + 2 * g * k * sinh(lp / k) * exp(d * lp) }
}
\examples{
require(graphics)

### Example 1
pp <- c(ppoints(11, a = 1), NA, NaN) ; pp
lp <- logit(pp) ; lp
qkiener3(  p = pp, m = 2, g = 1.5, k = aw2k(4, 6), d = aw2d(4, 6))
qlkiener3(lp = lp, m = 2, g = 1.5, k = aw2k(4, 6), d = aw2d(4, 6))
dpkiener3( p = pp, m = 2, g = 1.5, k = aw2k(4, 6), d = aw2d(4, 6))
dlkiener3(lp = lp, m = 2, g = 1.5, k = aw2k(4, 6), d = aw2d(4, 6))
dqkiener3( p = pp, m = 2, g = 1.5, k = aw2k(4, 6), d = aw2d(4, 6))


### Example 2
k       <- 4.8
d       <- 0.042
set.seed(2014)
mainTC  <- paste("qkiener3(p, m = 0, g = 1, k = ", k, ", d = ", d, ")")
mainsum <- paste("cumulated qkiener3(p, m = 0, g = 1, k = ", k, ", d = ", d, ")")
T       <- 500
C       <- 4
TC      <- qkiener3(p = runif(T*C), m = 0, g = 1, k = k, d = d)
matTC   <- matrix(TC, nrow = T, ncol = C, dimnames = list(1:T, letters[1:C]))
head(matTC)
plot.ts(matTC, main = mainTC)
#
matsum  <- apply(matTC, MARGIN=2, cumsum)
head(matsum)
plot.ts(matsum, plot.type = "single", main = mainsum)
### End example 2


### Example 3 (four plots: probability, density, logit, logdensity)
x     <- q  <- seq(-15, 15, length.out=101)
k     <- 3.2
d     <- c(-0.1, -0.03, -0.01, 0.01, 0.03, 0.1) ; names(d) <- d
olty  <- c(2, 1, 2, 1, 2, 1, 1)
olwd  <- c(1, 1, 2, 2, 3, 3, 2)
ocol  <- c(2, 2, 4, 4, 3, 3, 1)
lleg  <- c("logit(0.999) = 6.9", "logit(0.99)   = 4.6", "logit(0.95)   = 2.9",
           "logit(0.50)   = 0", "logit(0.05)   = -2.9", "logit(0.01)   = -4.6",
           "logit(0.001) = -6.9  ")
op    <- par(mfrow=c(2,2), mgp=c(1.5,0.8,0), mar=c(3,3,2,1))

plot(x, pkiener3(x, k = 3.2, d = 0), type = "l", lwd = 3, ylim = c(0, 1),
     xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "pkiener3(q, m, g, k=3.2, d=...)")
for (i in 1:length(d)) lines(x, pkiener3(x, k = 3.2, d = d[i]),
       lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("topleft", title = expression(delta), legend = c(d, "0"),
       cex = 0.7, inset = 0.02, lty = olty, lwd = olwd, col = ocol )

plot(x, dkiener3(x, k = 3.2, d = 0), type = "l", lwd = 3, ylim = c(0, 0.14),
     xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "dkiener3(q, m, g, k=3.2, d=...)")
for (i in 1:length(d)) lines(x, dkiener3(x, k = 3.2, d = d[i]),
       lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("topright", title = expression(delta), legend = c(d, "0"),
       cex = 0.7, inset = 0.02, lty = olty, lwd = olwd, col = ocol )

plot(x, lkiener3(x, k = 3.2, d = 0), type = "l", lwd =3, ylim = c(-7.5, 7.5),
     yaxt="n", xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "logit(pkiener3(q, m, g, k=3.2, d=...))")
axis(2, las=1, at=c(-6.9, -4.6, -2.9, 0, 2.9, 4.6, 6.9) )
for (i in 1:length(d)) lines(x, lkiener3(x, k = 3.2, d = d[i]),
       lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("topleft", legend = lleg, cex = 0.7, inset = 0.02 )
legend("bottomright", title = expression(delta), legend = c(d, "0"),
       cex = 0.7, inset = 0.02, lty = c(olty), lwd = c(olwd), col = c(ocol) )

plot(x, dkiener3(x, k = 3.2, d = 0, log = TRUE), type = "l", lwd = 3,
     ylim = c(-8, -1.5), xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "log(dkiener3(q, m, g, k=2, d=...))")
for (i in 1:length(d)) lines(x, dkiener3(x, k = 3.2, d = d[i], log=TRUE),
       lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("bottom", title = expression(delta), legend = c(d, "0"),
       cex = 0.7, inset = 0.02, lty = olty, lwd = olwd, col = ocol )
### End example 3


### Example 4 (four plots: quantile, derivate, density and quantiles from p)
p     <- ppoints(199, a=0)
d     <- c(-0.1, -0.03, -0.01, 0.01, 0.03, 0.1) ; names(d) <- d
op    <- par(mfrow=c(2,2), mgp=c(1.5,0.8,0), mar=c(3,3,2,1))

plot(p, qlogis(p, scale = 2), type = "l", lwd = 2, xlim = c(0, 1),
      ylim = c(-15, 15), xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "qkiener3(p, m, g, k=3.2, d=...)")
for (i in 1:length(d)) lines(p, qkiener3(p, k = 3.2, d = d[i]),
          lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("topleft", title = expression(delta), legend = c(d, "qlogis(x/2)"),
          inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

plot(p, 2/p/(1-p), type = "l", lwd = 2, xlim = c(0, 1), ylim = c(0, 100),
     xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "dqkiener3(p, m, g, k=3.2, d=...)")
for (i in 1:length(d)) lines(p, dqkiener3(p, k = 3.2, d = d[i]),
          lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("top", title = expression(delta), legend = c(d, "p*(1-p)/2"),
          inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

plot(qlogis(p, scale = 2), p*(1-p)/2, type = "l", lwd = 2, xlim = c(-15, 15),
     ylim = c(0, 0.14), xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "qkiener3, dpkiener3(p, m, g, k=3.2, d=...)")
for (i in 1:length(d)) {
     lines(qkiener3(p, k = 3.2, d = d[i]), dpkiener3(p, k = 3.2, d = d[i]),
           lty = olty[i], lwd = olwd[i], col = ocol[i] ) }
legend("topleft", title = expression(delta), legend = c(d, "p*(1-p)/2"),
          inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

plot(qlogis(p, scale = 2), p, type = "l", lwd = 2, xlim = c(-15, 15),
     ylim = c(0, 1), xaxs = "i", yaxs = "i", xlab = "", ylab = "",
     main = "inverse axis qkiener3(p, m, g, k=3.2, d=...)")
for (i in 1:length(d)) lines(qkiener3(p, k = 3.2, d = d[i]), p,
          lty = olty[i], lwd = olwd[i], col = ocol[i] )
legend("topleft", title = expression(delta), legend = c(d, "qlogis(x/2)"),
          inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )
### End example 4
}
\references{
P. Kiener, Explicit models for bilateral fat-tailed distributions and
applications in finance with the package FatTailsR, 8th R/Rmetrics Workshop
and Summer School, Paris, 27 June 2014. Download it from:
\url{http://www.inmodelia.com/exemples/2014-0627-Rmetrics-Kiener-en.pdf}
}
\seealso{
The symmetric Kiener distribution of type I \code{\link{kiener1}},
the asymmetric Kiener distributions of type II and IV
\code{\link{kiener2}}, \code{\link{kiener4}},
the conversion functions \code{\link{aw2k}},
the regression function \code{\link{regkienerLX}}.
}

