% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.ftrlprox.r
\name{update.ftrlprox}
\alias{update.ftrlprox}
\title{Update FTRL Proximal model}
\usage{
\method{update}{ftrlprox}(object, newX, newY, num_epochs = 1, save_loss = F,
  ...)
}
\arguments{
\item{object}{the model object}

\item{newX}{new feature vectors. This needs to be the same features as used in previous training rounds for this object.}

\item{newY}{new observations}

\item{num_epochs}{number of times we should traverse over the training data, defaults to 1.}

\item{save_loss}{is to save the loss function during training. This will be appended to previous loss vector.}

\item{...}{additional args}
}
\value{
ftrlprox model object
}
\description{
Continue training model on new data
}
\details{
As FTRL PRoximal is an online algorithm it is possible to continue training the model on new data. This can be good if for for example the size of the dataset is too large to keep in memory or new data is getting available after some time.
}
\author{
Vilhelm von Ehrenheim
}

