% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridFeatureSelection.R
\name{hybridFeatureSelection}
\alias{hybridFeatureSelection}
\title{Hybrid Feature Selection Proccess}
\usage{
hybridFeatureSelection(data, class, hybridSearcher, evaluator_1, evaluator_2)
}
\arguments{
\item{data}{A data.frame with the input dataset where the examples are in the rows and the features and the target variable are in the columns. The dataset should be discrete (feature columns are expected to be factors) if the following filter methods are used as evaluation methods: Rough Set Consistency, Binary Consistency, IE Consistency, IEP Consistency, Mutual Information, Gain Ratio, Symmetrical Uncertain, Gini Index or MDLC. The Jd and F-Score filter methods only work on classification problems with 2 classes in the target variable.}

\item{class}{The name of the dependent variable}

\item{hybridSearcher}{The algorithm to guide the hybrid search in the feature space. See \code{\link{hybridSearchAlgorithm}}.}

\item{evaluator_1}{The first evaluation method. This method can be a filter (see \code{\link{filterEvaluator}}) or a wrapper method (see \code{\link{wrapperEvaluator}}).}

\item{evaluator_2}{The second evaluation method. This method can be a filter (see \code{\link{filterEvaluator}}) or a wrapper method (see \code{\link{wrapperEvaluator}}). If the LCC algorithm is used, the measure must evaluate feature sets.}
}
\value{
A list is returned with the results of the hybrid feature selection process:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0.}
\item{bestValue}{Evaluation measure obtained with the feature selection.}
\item{evaluationType_1}{Type of evaluation based on how the features have been evaluated.}
\item{evaluationMethod_1}{Evaluation method used for the first evaluator.}
\item{measureType_1}{Type of evaluation measure for the first evaluator.}
\item{evaluationType_2}{Type of evaluation based on how the features have been evaluated for the first evaluator.}
\item{evaluationMethod_2}{Evaluation method used for the second evaluator.}
\item{measureType_2}{Type of evaluation measure for the second evaluator.}
\item{searchMethod}{Search method used during the feature selection process for the second evaluator.}
\item{target}{A character indicating if the objective of the process is to minimize or maximize the evaluation measure.}
\item{numFeatures}{Number of features in the problem.}
\item{xNames}{Name of the features.}
\item{yNames}{Name of the dependent variable.}
\item{time}{Value of class 'proc_time' containing the user time, system time, and total time of the feature selection process.}
}
}
\description{
Performs the hybrid feature selection process. Given a hybrid search algorithm and an two evaluation methods, it uses the hybrid search algorithm in combination with the evaluation results to guide the feature selection process to an optimal subset.
}
\examples{
\donttest{ 

## Examples of the hybrid feature selection process
## Classification problem with filter

# Generates the first filter evaluation function (individual or set measure)
f_evaluator_1 <- filterEvaluator('determinationCoefficient')
# Generates the second filter evaluation function (mandatory set measure)
f_evaluator_2 <- filterEvaluator('ReliefFeatureSetMeasure')
# Generates the hybrid search function
hybrid_search_method <- hybridSearchAlgorithm('LCC')
# Runs the hybrid feature selection process
res <- hybridFeatureSelection(iris,'Species',hybrid_search_method,f_evaluator_1,f_evaluator_2)


## Classification problem with wrapper

# Generates the first wrapper evaluation function (individual or set measure)
w_evaluator_1 <- wrapperEvaluator('rf')
# Generates the second wrapper evaluation function (mandatory set measure)
w_evaluator_2 <- wrapperEvaluator('knn')
# Generates the hybrid search function
hybrid_search_method <- hybridSearchAlgorithm('LCC')
# Runs the hybrid feature selection process
res <- hybridFeatureSelection(iris,'Species',hybrid_search_method,w_evaluator_1,w_evaluator_2)


## Classification problem mixed (with filter & wrapper)

# Generates the first filter evaluation function (individual or set measure)
f_evaluator <- filterEvaluator('determinationCoefficient')
# Generates the second wrapper evaluation function (mandatory set measure)
w_evaluator <- wrapperEvaluator('knn')
# Generates the hybrid search function
hybrid_search_method <- hybridSearchAlgorithm('LCC')
# Runs the hybrid feature selection process
res <- hybridFeatureSelection(iris, 'Species', hybrid_search_method, f_evaluator, w_evaluator)
}

}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
