% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{lvw}
\alias{lvw}
\title{Las Vegas Wrapper}
\usage{
lvw(data, class, featureSetEval, start = sample(0:1, ncol(data) - 1,
  replace = TRUE), K = 50, verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{start}{\itemize{
\item Binary vector with the set of initial features (1: selected and 0: unselected) for the algorithm
}}

\item{K}{\itemize{
\item The maximum number of iterations without improvement to finalize the algorithm
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{initialVector}{The vector with which the algorithm started}
\item{initialFitness}{The evaluation measure of the initial vector}
\item{trace}{Matrix with the results of each iteration. It contains the number of the iteration, the value of k, the best set of features selected by the algorithm up to that iteration (1: selected, 0: not selected) and the value of the evaluation measure obtained from that best set of features}
}
}
\description{
The lvw method  \insertCite{LiuSetiono1996}{FSinR} starts with a certain set of features and in each step a new set is randomly generated, if the new set is better it is saved as the best solution. The algorithm ends when there are no improvements in a certain number of iterations.
}
\examples{
## lvw method for iris dataset (filter method)
lvw(iris, 'Species', roughsetConsistency, K=15, verbose=TRUE)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
