% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FA2.R
\name{compute.fa2}
\alias{compute.fa2}
\title{FA2}
\usage{
compute.fa2(Y, X, verbose = F)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}

\item{verbose}{if TRUE, print advice about the quality of the model}
}
\description{
Calculate the FA2 between two univariate signals Y (imputed values) and X (true values).
}
\details{
This function returns the FA2 value which corresponds to the percentage of pairs of values (\eqn{x_{i}, y_{i}}) satisfying the condition \eqn{0,5 <= (y_{i}/x_{i}) <= 2}.
FA2 is close to 1, the imputation model is more accurate.
Both vectors Y and X must be of equal length, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.fa2(Y,X)
compute.fa2(Y,X, verbose = TRUE)

# By definition, if pairs of true and imputed values are zero,
# FA2 corresponding to this pair of values equals 1.
X[1] <- 0
Y[1] <- 0
compute.fa2(Y,X)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
