% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HalibutPAC.R
\docType{data}
\name{HalibutPAC}
\alias{HalibutPAC}
\title{Stock and recruitment data for Pacific Halibut, 1929-1991.}
\format{
A data frame of 63 observations on the following 5 variables:
 \describe{
   \item{year}{Year of data}
   \item{ssb}{Spawning stock biomass (tonnes)}
   \item{rec}{Recruits (thousands)}
   \item{land}{Landings (in millions of pounds)}
   \item{fmort}{Fishing related mortality}
 }
}
\source{
From Anonymous. 1989. International Pacific Halibut Commission. Annual Report 1989.; Myhre, Gordon, Peltonen, Stpierre, Skud, and Walden. International Pacific halibut Commission. Technical Report No. 14.; Pers. Comm. with Pat Sullivan. Obtained from Ransom Myers online database which was (is?) at http://ram.biology.dal.ca/~myers/data.html.
}
\description{
Pacific Halibut (\emph{Hippoglossus stenolepis}) stock, recruitment, landings, and fishing mortality by year, 1929-1991.
}
\section{Topic(s)}{

 \itemize{
   \item Stock-Recruit
   \item Recruitment
 }
}

\examples{
data(HalibutPAC)
str(HalibutPAC)
head(HalibutPAC)
op <- par(mfrow=c(1,2),pch=19)
plot(rec~year,data=HalibutPAC,type="l")
plot(rec~ssb,data=HalibutPAC)
par(op)

}
\concept{Recruitment}
\concept{Stock-Recruit}
\keyword{datasets}
