% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsVal.R
\name{wsVal}
\alias{wsVal}
\title{Finds standard weight equation coefficients for a particular species.}
\usage{
wsVal(species = "List", units = c("metric", "English"), ref = 75,
  simplify = FALSE)
}
\arguments{
\item{species}{A string that contains the species name for which to find coefficients.  See details.}

\item{units}{A string that indicates whether the coefficients for the standard weight equation to be returned are in (\code{"metric"} (DEFAULT; mm and g) or \code{"English"} (in and lbs) units.}

\item{ref}{A numeric that indicates which percentile the equation should be returned for.  Note that the vast majority of equations only exist for the \code{75}th percentile (DEFAULT).}

\item{simplify}{A logical that indicates whether the \sQuote{units}, \sQuote{ref}, \sQuote{measure}, \sQuote{method}, \sQuote{comments}, and \sQuote{source} fields should be included (\code{=FALSE}) or not (\code{=TRUE}; DEFAULT).  See details.}
}
\value{
A one row data frame from \code{\link{WSlit}} that contains all known information about the standard weight equation for a given species, type of measurement units, and reference percentile if \code{simplify=FALSE}.  If \code{simplify=TRUE} then only the species; minimum and maximum length for which the standard equation should be applied; and intercept, slope, and quadratic  coefficients for the standard weight equation.  Note that the maximum length and the quadratic coefficient will not be returned if they do not exist in \code{\link{WSlit}}.

If no arguments are given to this function, a species name is mis-spelled, or if a standard weight equation does not exist (in \code{\link{WSlit}}) for a particular species, then a warning will be issued and a list of species names will be printed.
}
\description{
Returns a vector that contains all known or a subset of information about the standard weight equation for a given species, type of measurement units, and reference percentile.
}
\details{
This function extract all known information from \code{\link{WSlit}} about the following standard weight equation,

\deqn{log_{10}(Ws) = log_{10}(a) + blog_{10}(L) + blog_{10}(L)^{2}}

See \code{\link{WSlit}} for more information about the meaning of each value returned.

Note from above that the coefficients are returned for the TRANSFORMED model.  Thus, to obtain the standard weight (Ws), the returned coefficients are used to compute the common log of Ws which must then bed raised to the power of 10 to compute the Ws.
}
\section{IFAR Chapter}{
 8-Condition.
}

\examples{
wsVal()
wsVal("Bluegill")
wsVal("Bluegill",units="metric")
wsVal("Bluegill",units="English")
wsVal("Bluegill",units="English",simplify=TRUE)
wsVal("Ruffe",units="metric",simplify=TRUE)
wsVal("Ruffe",units="metric",ref=50,simplify=TRUE)

}
\references{
Ogle, D.H.  2016.  \href{http://derekogle.com/IFAR}{Introductory Fisheries Analyses with R}.  Chapman & Hall/CRC, Boca Raton, FL.
}
\seealso{
See \code{\link{wrAdd}} and \code{\link{WSlit}} for related functionality.
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\keyword{manip}
