% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/stockRecruitment.R
\name{stockRecruitment}
\alias{srFuns}
\alias{srModels}
\alias{stockRecruitment}
\title{Creates a function for a specific parameterization of a common stock-recruitment model .}
\usage{
srFuns(type = c("BevertonHolt", "Ricker", "Shepherd", "SailaLorda",
  "independence"), param = 1, simple = FALSE, msg = FALSE)

srModels(...)
}
\arguments{
\item{type}{A string that indicates the type of stock-recruitment model.}

\item{param}{A single numeric that indicates the parameterization of the stock-recruitment model type.}

\item{simple}{A logical that indicates whether the user should be allowed to send all parameter values in the first parameter argument (\code{=FALSE}; default) or whether all individual parameters must be specified (\code{=TRUE}).}

\item{msg}{A logical that indicates whether a message about the model and parameter definitions should be output (\code{=TRUE}) or not (\code{=FALSE}; default).}

\item{\dots}{Not implemented.}
}
\value{
\code{srFuns} returns a function that can be used to predict recruitment given a vector of stock sizes and values for the model parameters.  The result should be saved to an object that can then be used as a function name.  When the resulting function is used, the parameters are ordered as shown when the definitions of the parameters are printed after the function is called (assuming that \code{msg=TRUE}).  The values for both/all parameters can be included as a vector of length two/three in the first parameter argument.  If \code{simple=FALSE} then the values for all parameters can be included as a vector in the first parameter argument.  If \code{simple=TRUE} then all parameters must be declared individually in each function.  The resulting function is somewhat easier to read when \code{simple=TRUE}.

\code{srModels} returns a graphic that uses \code{\link{plotmath}} to show the model formulae in a pretty format.
}
\description{
Creates a function for a specific parameterization of a \dQuote{Beverton-Holt}, \dQuote{Ricker},  \dQuote{Shepherd}, or \dQuote{Saila-Lorda} stock-recruitment model.  Use \code{srModels()} to see the equations of each model.
}
\section{IFAR Chapter}{
 13-Recruitment.
}
\examples{
## See the formulae
\dontrun{windows(6,5)}
srModels()

## Simple Examples
# show what a message looks like with the function definition
srFuns("Ricker",msg=TRUE)

# create some dummy stock data
stock <- seq(0.01,1000,length.out=199)

# Beverton-Holt #1 parameterization
( bh1 <- srFuns() )
plot(bh1(stock,a=0.5,b=0.01)~stock,type="l",lwd=2,ylab="Recruits",xlab="Spawners",ylim=c(0,50))

# Ricker #1 parameterization
( r1 <- srFuns("Ricker") )
lines(r1(stock,a=0.5,b=0.005)~stock,lwd=2,col="red")

# Shephered parameterization
( s1 <- srFuns("Shepherd") )
lines(s1(stock,a=0.5,b=0.005,c=2.5)~stock,lwd=2,col="blue")

# Saila-Lorda parameterization
( sl1 <- srFuns("SailaLorda") )
lines(sl1(stock,a=0.5,b=0.005,c=1.05)~stock,lwd=2,col="salmon")

## Examples of fitting stock-recruitment models
data(CodNorwegian)

# Fitting the Beverton-Holt #1 parameterization with multiplicative errors
bh1s <- srStarts(recruits~stock,data=CodNorwegian)
fit1 <- nls(log(recruits)~log(bh1(stock,a,b)),data=CodNorwegian,start=bh1s)
summary(fit1,correlation=TRUE)
plot(recruits~stock,data=CodNorwegian,pch=19,xlim=c(0,200))
curve(bh1(x,a=coef(fit1)[1],b=coef(fit1)[2]),from=0,to=200,col="red",lwd=3,add=TRUE)

# Fitting the Ricker #3 parameterization with multiplicative errors
r3 <- srFuns("Ricker",param=3)
r3s <- srStarts(recruits~stock,data=CodNorwegian,type="Ricker",param=3)
fit2 <- nls(log(recruits)~log(r3(stock,a,Rp)),data=CodNorwegian,start=r3s)
summary(fit2,correlation=TRUE)
curve(r3(x,a=coef(fit2)[1],Rp=coef(fit2)[2]),from=0,to=200,col="blue",lwd=3,add=TRUE)
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}, thanks to Gabor Grothendieck for a hint about using \code{get()}.
}
\references{
Ogle, D.H.  2015.  \href{http://derekogle.com/IFAR}{Introductory Fisheries Analyses with R}.  Chapman & Hall/CRC, Boca Raton, FL.

Beverton, R.J.H. and S.J. Holt.  1957.  On the dynamics of exploited fish populations, Fisheries Investigations (Series 2), volume 19. United Kingdom Ministry of Agriculture and Fisheries, 533 pp.

Iles, T.C.  1994.  A review of stock-recruitment relationships with reference to flatfish populations.  Netherlands Journal of Sea Research 32:399-420.

Quinn II, T.J. and R.B. Deriso. 1999. Quantitative Fish Dynamics. Oxford University Press.

Ricker, W.E. 1954. Stock and recruitment. Journal of the Fisheries Research Board of Canada 11:559-623.

Ricker, W.E. 1975. \href{http://www.dfo-mpo.gc.ca/Library/1485.pdf}{Computation and interpretation of biological statistics of fish populations}. Technical Report Bulletin 191, Bulletin of the Fisheries Research Board of Canada.

Shepherd, J. 1982. A versatile new stock-recruitment relationship for fisheries and construction of sustainable yield curves. Journal du Conseil International pour l'Exploration de la Mar 40:67-75.
}
\seealso{
See \code{\link{srStarts}} for related functionality.
}
\keyword{manip}

