% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FRESHD_predict.R
\name{predict.FRESHD}
\alias{predict.FRESHD}
\alias{FRESHD_predict}
\alias{FRESHD.predict}
\title{Make Prediction From a FRESHD Object}
\usage{
\method{predict}{FRESHD}(object, x, ...)
}
\arguments{
\item{object}{An object of class FRESHD, produced with \code{maximin} or \code{magging}.}

\item{x}{An object that should be like the input to the call
that produced \code{object}. For models with custom design a list like the one
supplied to produce \code{object} and for a wavelet design
the name of the wavelet used to produce \code{object}.}

\item{...}{ignored.}
}
\value{
If \code{x} is a string indicating a wavelet an array of the same size
as the input data used to produce \code{object}. Otherwise an array of size
\eqn{n'_1 \times \cdots \times n'_d}, with \eqn{d\in \{1,2,3\}}.
}
\description{
Given covariate data this function computes the linear predictors
based on the estimated model coefficients in an object produced by the function
\code{maximin} or \code{magging}. Note that the data can be supplied in two different
formats:
i) for wavelet based models as a string indicating the wavelet used to produce
the model object.
ii) for  models with custom design as a list of one, two or three Kronecker component
matrices each of size \eqn{n_i' \times p_i, i = 1, 2, 3}. Note \code{x} will
typically be the original design (covariate data) that was used to produce \code{object}
using \code{maximin} or \code{magging} so \eqn{n_i'} is the number of
marginal data points in the \eqn{i}th dimension i.e. \eqn{n_i' = n_i}.
}
\examples{
##size of example
set.seed(42)
G = 50; N1 = 2^10; p = 101; J = 3; amp = 20; sigma2 = 10
y <- matrix(0, N1, G)
z <- seq(0, 2, length.out = N1)
sig <- cos(10 * pi * z) + 1.5 * sin(5 * pi * z)
for (i in 1:G){
freqs <- sample(1:100, size = J, replace = TRUE)
y[, i] <- sig * 2 + rnorm(N1, sd = sqrt(sigma2))
for (j in 1:J){
y[, i] <- y[, i] + amp * sin(freqs[j] * pi * z + runif(1, -pi, pi))
}
}
system.time(fitmm <- maximin(y, "la8", alg = "aradmm", kappa = 0.95))
mmy <- predict(fitmm, "la8")
plot(mmy[, 2], type = "l")
lines(sig, col = "red")

}
\author{
Adam Lund
}
