% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modGBchng.R
\name{modGBchng}
\alias{modGBchng}
\title{Green-Book module - Generate area estimates.}
\usage{
modGBchng(
  GBpopdat,
  chngtype = "total",
  landarea = "FOREST",
  pcfilter = NULL,
  rowvar = NULL,
  colvar = NULL,
  sumunits = TRUE,
  returntitle = FALSE,
  savedata = FALSE,
  table_opts = NULL,
  title_opts = NULL,
  savedata_opts = NULL,
  gui = FALSE,
  ...
)
}
\arguments{
\item{GBpopdat}{List. Population data objects returned from modGBpop().}

\item{chngtype}{String. The type of change estimates ('total', 'annual').}

\item{landarea}{String. The sample area filter for estimates ("ALL",
"FOREST", "TIMBERLAND").  If landarea=FOREST, filtered to COND_STATUS_CD =
1; If landarea=TIMBERLAND, filtered to SITECLCD in(1:6) and RESERVCD = 0.}

\item{pcfilter}{String. A filter for plot or cond attributes (including
pltassgn).  Must be R logical syntax.}

\item{rowvar}{String. Name of row domain variable in cond. If only one
domain, rowvar = domain variable. If more than one domain, include colvar.
If no domain, rowvar = NULL.}

\item{colvar}{String. Name of column domain variable in cond.}

\item{sumunits}{Logical. If TRUE, estimation units are summed and returned
in one table.}

\item{returntitle}{Logical. If TRUE, returns title(s) of the estimation
table(s).}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{table_opts}{List. See help(table_options()) for a list of
options.}

\item{title_opts}{List. See help(title_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{...}{Parameters for modGBpop() if GBpopdat is NULL.}
}
\value{
A list with estimates with percent sampling error for rowvar (and
colvar).  If sumunits=TRUE or unitvar=NULL and colvar=NULL, one data frame
is returned.  Otherwise, a list object is returned with the following
information.  If savedata=TRUE, all data frames are written to outfolder.

\item{est}{ Data frame. Area estimates, in area units (e.g., acres), by
rowvar, colvar (and estimation unit). If sumunits=TRUE or one estimation
unit and colvar=NULL, or allin1=TRUE, estimates and percent sampling error
are in one data frame. } 
\item{pse}{ Data frame. Percent sampling errors (Confidence level 68%) 
for estimates by rowvar and colvar (and estimation unit). } 
\item{titlelst}{ List. If returntitle=TRUE a list with table title(s). The 
list contains one title if est and pse are in the same table and two titles 
if est and pse are in separate tables. Row and column tables are also included 
in list. } 
\item{raw}{ List. If rawdata=TRUE, a list including the processing data used 
for estimation including: number of plots and conditions; stratification 
information; and 1 to 8 tables with calculated values for table cells and 
totals (See processing data below). }

Raw data

\item{plotsampcnt}{ Table. Number of plots by plot status (e.g., sampled
forest on plot, sampled nonforest, nonsampled). } 
\item{condsampcnt}{ DF. Number of conditions by condition status 
(forest land, nonforest land, noncensus water, census water, nonsampled). } 
\item{unitarea}{ DF. Area by estimation unit. } 
\item{expcondtab}{ DF. Condition-level area expansion factors. } 
\item{domdat}{ DF. Final data table used for estimation. }

\item{stratdat}{ Data frame. Strata information by estimation unit. }
\tabular{lll}{ \tab \bold{Variable} \tab \bold{Description} \cr
\tab unitvar \tab estimation unit \cr \tab strvar \tab stratum value \cr 
\tab strwtvar \tab number of pixels by strata and estimation unit \cr 
\tab n.strata \tab number of plots in strata (after totally nonsampled 
plots removed) \cr 
\tab n.total \tab number of plots for estimation unit \cr 
\tab strwt \tab proportion of area (or plots) by strata and estimation 
unit (strata weight) \cr \tab CONDPROP_UNADJ_SUM \tab summed condition 
proportion by strata and estimation unit \cr 
\tab CONDPROP_ADJFAC \tab adjusted condition proportion by strata after 
nonresponse plots removed \cr 
\tab AREA \tab total area for estimation unit \cr 
\tab CONDPROP_ADJFAC \tab average area \cr }

\item{processing data}{ Data frames. Separate data frames containing
calculated variables used in estimation process. The number of processing
tables depends on the input parameters. The tables include: total by
estimation unit (unit.totest); rowvar totals (unit.rowest), colvar totals,
if not NULL (unit.colvar); and a combination of rowvar and colvar, if colvar
is not NULL (unit.grpvar). If sumunits=TRUE, the raw data for the summed
estimation units are also included (totest, rowest, colest, grpest,
respectively).  These tables do not included estimate proportions (nhat and
nhat.var).

The data frames include the following information: \tabular{lll}{ \tab
\bold{Variable} \tab \bold{Description}\cr 
\tab nhat \tab estimate proportion of land \cr 
\tab nhat.var \tab variance estimate of estimated proportion of land \cr 
\tab NBRPLT.gt0 \tab Number of non-zero plots used in estimates \cr 
\tab AREA \tab total area for estimation unit \cr 
\tab est \tab estimated area of land nhat*areavar \cr 
\tab est.var \tab variance estimate of estimate acres of land 
nhat.var*areavar^2 \cr 
\tab est.se \tab standard error of estimated area of land sqrt(est.var) \cr 
\tab est.cv \tab coefficient of variation of estimated area of land est.se/est 
\cr \tab pse \tab percent sampling error of estimate est.cv*100 \cr 
\tab CI99left \tab left tail of 99 percent confidence interval for 
estimated area \cr 
\tab CI99right \tab right tail of 99 percent confidence interval for 
estimated area \cr 
\tab CI95left \tab left tail of 95 percent confidence interval for 
estimated area \cr 
\tab CI95right \tab right tail of 95 percent confidence interval for 
estimated area \cr 
\tab CI67left \tab left tail of 67 percent confidence interval for 
estimated area \cr 
\tab CI67right \tab right tail of 67 percent confidence interval for 
estimated area \cr } }

savedata\cr 
if savedata=TRUE...\cr 
tables with estimate and percent standard error will be written as *csv 
files to outfolder.  if rawdata=TRUE, the rawdata will be output to the 
outfolder in a folder named rawdata (if raw_fmt="csv") or a database in 
the outfolder, if (raw_fmt != "csv").

if outfn.pre is not null...\cr 
a prefix is added to output files if raw_fmt = 'csv', prefix is added to 
file names in rawdata folder if raw_fmt != 'csv', prefix is added to dsn name
}
\description{
Generates area estimates by domain (and estimation unit). Calculations are
based on Scott et al. 2005 ('the green-book') for mapped forest inventory
plots. The non-ratio estimator for estimating area by stratum and domain is
used. Plots that are totally nonsampled are excluded from estimation
dataset. Next, an adjustment factor is calculated by strata to adjust for
nonsampled (nonresponse) conditions that have proportion less than 1. The
attribute is the proportion of the plot which is divided by the adjustment
factor, and averaged by stratum. Strata means are combined using the strata
weights and then expanded to area using the total land area in the
population.
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr 
\tabular{llll}{ \tab \bold{Data} 
\tab \bold{Variable} \tab \bold{Description}\cr 
\tab cond \tab cuniqueid \tab Unique identifier for each plot, to link to pltassgn (ex. PLT_CN).\cr \tab
\tab CONDID \tab Unique identifier of each condition on plot.  Set CONDID=1,
if only 1 condition per plot.\cr 
\tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on each plot. Set CONDPROP_UNADJ=1, if only 1
condition per plot.\cr 
\tab \tab COND_STATUS_CD \tab Status of each forested condition on plot (i.e. accessible forest, nonforest, water, etc.)\cr \tab
\tab NF_COND_STATUS_CD \tab If ACI=TRUE. Status of each nonforest condition
on plot (i.e. accessible nonforest, nonsampled nonforest)\cr 
\tab \tab SITECLCD \tab If landarea=TIMBERLAND. Measure of site productivity.\cr \tab
\tab RESERVCD \tab If landarea=TIMBERLAND. Reserved status.\cr

\tab pltassgn \tab puniqueid \tab Unique identifier for each plot, to link
to cond (e.g., CN).\cr 
\tab \tab STATECD \tab Identifies state each plot is located in.\cr \tab \tab INVYR \tab Identifies inventory year of each
plot.\cr 
\tab \tab PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, nonsampled). If not included, all plots are assumed as sampled.\cr }

For available reference tables: sort(unique(FIESTAutils::ref_codes$VARIABLE)) \cr
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions. It is calculated for each estimation unit by strata
by summing the unadjusted condition proportions (CONDPROP_UNADJ) and
dividing by the number of plots in the strata/estimation unit.

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor. This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

STRATA:\cr Stratification is used to reduce variance in population estimates
by partitioning the population into homogenous classes (strata), such as
forest and nonforest. For stratified sampling methods, the strata sizes
(weights) must be either known or estimated. Remotely-sensed data is often
used to generate strata weights with proporation of pixels by strata. If
stratification is desired (strata=TRUE), the required data include: stratum
assignment for the center location of each plot, stored in either pltassgn
or cond; and a look-up table with the area or proportion of the total area
of each strata value by estimation unit, making sure the name of the strata
(and estimation unit) variable and values match the plot assignment name(s)
and value(s).

sumunits:\cr An estimation unit is a population, or area of interest, with
known area and number of plots. Individual counties or combined
Super-counties are common estimation units for FIA. An estimation unit may
also be a subpopulation of a larger population (e.g., Counties within a
State). Subpopulations are mutually exclusive and independent within a
population, therefore estimated totals and variances are additive. For
example, State-level estimates are generated by summing estimates from all
subpopulations within the State (Bechtold and Patterson. 2005. Chapter 2).
Each plot must be assigned to only one estimation unit.

If sumunits=TRUE, estimates are generated by estimation unit, summed
together, and returned as one estimate. If rawdata=TRUE, estimates by
individual estimation unit are also returned.

If sumunits=FALSE, estimates are generated and returned by estimation unit
as one data frame. If savedata=TRUE, a separate file is written for each
estimation unit.

stratcombine:\cr If TRUE and less than 2 plots in any one estimation unit,
all estimation units with 10 or less plots are combined. The current method
for combining is to group the estimation unit with less than 10 plots with
the estimation unit following in consecutive order (numeric or
alphabetical), restrained by survey unit (UNITCD) if included in dataset,
and continuing until the number of plots equals 10. If there are no
estimation units following in order, it is combined with the estimation unit
previous in order.

rowlut/collut:\cr There are several objectives for including rowlut/collut
look-up tables: 1) to include descriptive names that match row/column codes
in the input table; 2) to use number codes that match row/column names in
the input table for ordering rows; 3) to add rows and/or columns with 0
values for consistency. No duplicate names are allowed.

Include 2 columns in the table:\cr 1-the merging variable with same name as
the variable in the input merge table;\cr 2-the ordering or descriptive
variable.\cr If the ordering variable is the rowvar/colvar in the input
table and the descriptive variable is in rowlut/collut, set
row.orderby/col.orderby equal to rowvar/colvar. If the descriptive variable
is the rowvar/colvar in the input table, and the ordering code variable is
in rowlut/collut, set row.orderby/col.orderby equal to the variable name of
the code variable in rowlut/collut.
}
\references{
Scott, Charles T.; Bechtold, William A.; Reams, Gregory A.;
Smith, William D.; Westfall, James A.; Hansen, Mark H.; Moisen, Gretchen G.
2005. Sample-based estimators used by the Forest Inventory and Analysis
national information management system. Gen. Tech. Rep. SRS-80.  Asheville,
NC: U.S. Department of Agriculture, Forest Service, Southern Research
Station, p.53-77.
}
\author{
Tracey S. Frescino, Paul L. Patterson, Elizabeth A. Freeman
}
\keyword{data}
