% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spExportSpatial.R
\name{spExportSpatial}
\alias{spExportSpatial}
\title{Spatial - Exports an sf object.}
\usage{
spExportSpatial(sfobj, savedata_opts = NULL)
}
\arguments{
\item{sfobj}{sf class R object. Spatial object to export.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options for saving data. If out_layer = NULL, default = 'datsp'.}
}
\value{
An sf spatial object is written to outfolder.
}
\description{
Exports an sf object to a specified output.
}
\details{
Wrapper for sf::st_write function.
}
\note{
If out_fmt='shp':\cr The ESRI shapefile driver truncates variable
names to 10 characters or less. Variable names are changed before export
using an internal function (trunc10shp). Name changes are output to the
outfolder, 'out_layer'_newnames.csv.

If sf object has more than 1 record, it cannot be exported to a shapefile.
}
\examples{
# Set up data from FIESTA
WYbh <- spImportSpatial(system.file("extdata",
                                    "sp_data/WYbighorn_adminbnd.shp",
                                    package = "FIESTA"))

# Export data with spExportSpatial
spExportSpatial(WYbh,
                savedata_opts = list(out_dsn = "WYbh.shp", 
                                     outfolder = tempdir(), 
                                     overwrite_dsn = TRUE))
}
\author{
Tracey S. Frescino
}
\keyword{data}
