% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{summary.femlm}
\alias{summary.femlm}
\title{Summary of a \code{femlm} object. Computes different types of standard errors.}
\usage{
\method{summary}{femlm}(object, se = c("standard", "white", "cluster",
  "twoway", "threeway", "fourway"), cluster, dof_correction = FALSE,
  forceCovariance = FALSE, keepBounded = FALSE, ...)
}
\arguments{
\item{object}{A femlm object. Obtained using \code{\link[FENmlm]{femlm}}.}

\item{se}{Character scalar. Which kind of standard error should be prompted: \dQuote{standard} (default), \dQuote{White}, \dQuote{cluster}, \dQuote{twoway}, \dQuote{threeway} or \dQuote{fourway}?}

\item{cluster}{A list of vectors. Used only if \code{se="cluster"}, \dQuote{se=twoway}, \dQuote{se=threeway} or \dQuote{se=fourway}. The vectors should give the cluster of each observation. Note that if the estimation was run using \code{cluster}, the standard error is automatically clustered along the cluster given in \code{\link[FENmlm]{femlm}}. For one-way clustering, this argument can directly be a vector (instead of a list).}

\item{dof_correction}{Logical, default is \code{TRUE}. Should there be a degree of freedom correction to the standard errors of the coefficients?}

\item{forceCovariance}{Logical, default is \code{FALSE}. In the peculiar case where the obtained Hessian is not invertible (usually because of collinearity of some variables), use this option force the covariance matrix, by using a generalized inverse of the Hessian. This can be useful to spot where possible problems come from.}

\item{keepBounded}{Logical, default is \code{FALSE}. If \code{TRUE}, then the bounded coefficients (if any) are treated as unrestricted coefficients and their S.E. is computed (otherwise it is not).}

\item{...}{Not currently used.}
}
\value{
It returns a \code{femlm} object with:
\item{cov.scaled}{The new variance-covariance matrix (computed according to the argument \code{se}).}
\item{coeftable}{The table of coefficients with the new standard errors.}
}
\description{
This function is similar to \code{print.femlm}. It provides the table of coefficients along with other information on the fit of the estimation. It can compute different types of standard errors. The new variance covariance matrix is an object returned.
}
\examples{

# The data
n = 100
x = rnorm(n,1,5)**2
y = rnorm(n,-1,5)**2
z = rpois(n,x*y) + rpois(n, 2)
base = data.frame(x,y,z)

# Comparing the results of a 'linear' function
est0L = femlm(z~log(x)+log(y), base, family="poisson")

# Displaying the summary
summary(est0L, se="white")
myWhiteVcov = summary(est0L, se="white")$cov.scaled

}
\seealso{
See also the main estimation function \code{\link[FENmlm]{femlm}}. Use \code{\link[FENmlm]{getFE}} to extract the cluster coefficients, and the functions \code{\link[FENmlm]{res2table}} and \code{\link[FENmlm]{res2tex}} to visualize the results of multiple estimations.
}
\author{
Laurent Berge
}
