% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power.fisher}
\alias{power.fisher}
\title{Compute power for Fisher's exact test}
\usage{
power.fisher(p1, p2, n, alpha, alternative)
}
\arguments{
\item{p1}{probability in one group (scalar)}

\item{p2}{probability in other group (scalar)}

\item{n}{per-group sample size (scalar)}

\item{alpha}{p-value threshold (scalar)}

\item{alternative}{one- or two-sided test, must be one of "greater", "less", or "two.sided"}
}
\value{
Power estimate for one- or two-sided tests
}
\description{
Compute power for Fisher's exact test
}
\examples{
power.fisher(p1 = 0.5, p2 = 0.9, n=20, alpha = 0.05, alternative = 'two.sided')
}
