% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{gaussian.loglik}
\alias{gaussian.loglik}
\title{Log likelihood function for gaussian regression with a Jeffreys prior and BIC approximation of MLIK with both known and unknown variance of the responses}
\usage{
gaussian.loglik(y, x, model, complex, mlpost_params)
}
\arguments{
\item{y}{A vector containing the dependent variable}

\item{x}{The matrix containing the precalculated features}

\item{model}{The model to estimate as a logical vector}

\item{complex}{A list of complexity measures for the features}

\item{mlpost_params}{A list of parameters for the log likelihood, supplied by the user}
}
\value{
A list with the log marginal likelihood combined with the log prior (crit) and the posterior mode of the coefficients (coefs).
}
\description{
Log likelihood function for gaussian regression with a Jeffreys prior and BIC approximation of MLIK with both known and unknown variance of the responses
}
\examples{
gaussian.loglik(rnorm(100), matrix(rnorm(100)), TRUE, list(oc = 1), NULL)


}
