% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolicanalysis.R
\name{synthesisAnalysis}
\alias{synthesisAnalysis}
\title{De novo synthesis analysis of fatty acids until 16 carbons.}
\usage{
synthesisAnalysis(
  fadata,
  R2Thr = 0.98,
  maxiter = 1000,
  maxconvergence = 100,
  D1 = NA,
  D2 = NA,
  P = NA,
  startpoints = 5,
  parameters = FAMetA::parameters,
  propagateD = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{fadata}{fadata obtained from the msbatch with \link{searchFAisotopes}
function or read from csv file with \link{readfadatafile} function.}

\item{R2Thr}{positive numeric between 0 and 1 specifying the minimum R2
allowed for fits.}

\item{maxiter}{parameter passed to \link{nls.control}. Positive integer
specifying the maximum number of iterations allowed.}

\item{maxconvergence}{positive integer specifying the maximum number of
successes before choosing the winning model.}

\item{D1}{positive numeric between 0 and 1 specifying the contribution of
acetate M+1. If NA it is estimated.}

\item{D2}{positive numeric between 0 and 1 specifying the contribution of
acetate M+2. If NA it is estimated.}

\item{P}{overdispersion parameter. If NA it is estimated (quasi-multinomial
distribution). If set to 0, no overdispersion is assumed (multinomial
distribution).}

\item{startpoints}{positive integer specifying the number of starting points
for each parameter to be estimated.}

\item{parameters}{parameters to be estimated for each fatty acid. It can be
modified to change them or to add new fatty acids.}

\item{propagateD}{logical. If TRUE, unsaturated fatty acids use estimated D0,
D1,D2 and P values for saturated fatty acids (14:0 for FA shorter than 16C
and 16:0 for FA with 16C.).}

\item{verbose}{print information messages.}
}
\value{
fadata list. Synthesis analysis results will be saved at the 
synthesis element of the fa list.
}
\description{
De novo synthesis analysis of fatty acids until 16 carbons.
}
\details{
Synthesis analysis will model FA data for FA up to 16 carbons to
estimate 13C-tracer contribution to the acetyl-CoA pool for FA synthesis (D)
and the FA fraction that has been synthesized de novo. D0, D1 and D2
represent the contribution of M+0, M+1 and M+2 acetate, respectively, and P
(phi) is the overdispersion parameter of the quasi-multinomial distribution.
D0, D1, D2 can also be fixed if they are known. This is particularly useful
in case inhibitors have been used as they could reduce S below the confidence
interval and thus, S and D parameters could be misestimated.
}
\examples{
\donttest{
ssdata <- dataCorrection(ssexamplefadata, blankgroup="Blank")
ssdata <- synthesisAnalysis(ssdata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)
}

\dontrun{
fadata <- dataCorrection(examplefadata, blankgroup = "Blank")
fadata <- synthesisAnalysis(fadata, R2Thr = 0.95, maxiter = 1e3,
maxconvergence = 100, startpoints = 5)

# If inhibitors have been used, make sure D2 has not been underestimated. If so,
# D2 could be set as the one calculated for 13-Glc Control samples to improve
# the results:

# D2 <- fadata$synthesis$results$D2[fadata$synthesis$results$FA == "FA(16:0)"]
# fadata$synthesis$results$Group[fadata$synthesis$results$FA == "FA(16:0)"]

# D2[4:12] <- rep(mean(D2[1:3]))

# relaunch synthesis analysis fixing D2
# fadata <- synthesisAnalysis(fadata, R2Thr = 0.95, maxiter = 1e3,
#                             maxconvergence = 100, startpoints = 5, D2 = D2)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
