% Generated by roxygen2 (4.0.0): do not edit by hand
\name{confreg}
\alias{confreg}
\alias{confreg.jointPredictiveSample}
\title{Construct confidence regions for exceedance (excurions) sets.}
\usage{
confreg(obj, ...)

\method{confreg}{jointPredictiveSample}(obj, level, conf.level = 0.95,
  direction = ">", type = "o", method = 1, statistic = 1, ...)
}
\arguments{
\item{obj}{An object of class \code{jointPredictiveSample}.}

\item{level}{The threshold level for the exceedance region.}

\item{conf.level}{The confidence level of the confidence region.  Default is 0.95.}

\item{direction}{The direction of the exceedance region.  \code{">"} indicates the exceedance region is values above a threshold, while \code{"<"} indicates values below a threshold.}

\item{type}{\code{"o"} indicates on outer confidence region while \code{"i"} indicates in inner confidence region.}

\item{method}{If \code{method == 1}, then the region is constructed using a (test) statistic based procedure.  If \code{method == 2}, then the region is constructed directly.}

\item{statistic}{The type of statistic to use if \code{method == 1}.  If \code{statistic == 1}, then the statistic at each site is (prediction - level)/sqrt(mse).  If \code{statistic == 2}, then the statistic at each site is (prediction - level)/E[(Y - level)^2].  If \code{statistic == 3}, then the statistic is simply the predictive probability that the response is above (or below depending on context) the threshold \code{level}.}

\item{...}{Currently unimplemented.}
}
\value{
Returns an object of class \code{confreg} with the following components:
\item{confidence}{The sites included in the confidence region.}
\item{complement}{The complement of the confidence region.}
}
\description{
\code{confreg} constructs confidence regions for the exceedance (excursions) sets of geostatistical processes.
}
\details{
If type == \code{"o"}, then an outer confidence region is constructed.  The outer confidence region should entirely contain the true exceedanace region with high confidence.  If type == \code{"i"}, then an inner confidence region is constructed.  The inner confidence region should be entirely contained within the true exceedanace region with high confidence.
}
\examples{
# Set parameters
n <- 100
mygrid = create.pgrid(0, 1, 0, 1, nx = 5, ny = 4)
n.samples <- 10
burnin.start <- 1
sigmasq <- 1
tausq <- 0.0
phi <- 1
cov.model <- "exponential"
n.report <- 5

# Generate coordinates
coords <- matrix(runif(2 * n), ncol = 2)
pcoords <- mygrid$pgrid
# Construct design matrices
X <- as.matrix(cbind(1, coords))
Xp <- cbind(1, pcoords)

# Specify priors
starting <- list("phi" = phi, "sigma.sq"= sigmasq, "tau.sq" = tausq)
tuning <- list("phi"=0.1, "sigma.sq"=0.1, "tau.sq"=0.1)
priors.1 <- list("beta.Norm"=list(c(1, 2, 1), diag(100, 3)), "phi.Unif"=c(0.00001, 10),
 "sigma.sq.IG"=c(1, 1))

# Generate data
library(SpatialTools)
B <- rnorm(3, c(1, 2, 1), sd = 10)
phi <- runif(1, 0, 10)
sigmasq <- 1/rgamma(1, 1, 1)
V <- simple.cov.sp(D = dist1(coords), cov.model, c(sigmasq, 1/phi), error.var = tausq,
 smoothness = nu, finescale.var = 0)
y <- X \%*\% B + rmvnorm(1, rep(0, n), V) + rnorm(n, 0, sqrt(tausq))

# Create spLM object
library(spBayes)
m1 <- spBayes::spLM(y ~ X - 1, coords = coords, starting = starting, tuning = tuning,
 priors = priors.1, cov.model = cov.model, n.samples = n.samples, verbose = FALSE,
 n.report = n.report)

# Sample from joint posterior predictive distribution
y1 <- spLMPredictJoint(m1, pred.coords = pcoords, pred.covars = Xp,
 start = burnin.start, verbose = FALSE, method = "chol")
myconf = confreg(y1, level = quantile(y, .5), direction = ">", type = "o", method = 1,
 statistic = 1)
}
\author{
Joshua French
}

