% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{worldbank_data_def}
\alias{worldbank_data_def}
\title{Data Definitions for \code{worldbank} Data Set}
\format{An object of class \code{"data.frame"}.}
\usage{
data(worldbank_data_def)
}
\description{
A data frame containing variable definitions for the \code{worldbank} data set.
The data definitions can be passed to \code{\link{ExPanD}} via the
\code{df_def} parameter.
}
\details{
Data definitions are as provided by the World Bank API and
the code to generate them is available in the
 \href{https://github.com/joachim-gassen/ExPanDaR}{github repository}
 of this package.
}
\examples{
data(worldbank)
data(worldbank_data_def)
data(worldbank_var_def)
data(ExPanD_config_worldbank)
\dontrun{
  ExPanD(worldbank,df_def = worldbank_data_def,
    var_def = worldbank_var_def, config_list = ExPanD_config_worldbank)
}
}
\keyword{datasets}
