/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.inference.distribution.SplineInterpolatedLikelihood;
import java.util.List;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;

public class ExtendingEmpiricalDataModel
extends EmpiricalDataModel {
    public ExtendingEmpiricalDataModel(String string) {
        super(string);
    }

    public ExtendingEmpiricalDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> list) {
        return new SplineInterpolatedLikelihood(list, 1, false){
            private static final long serialVersionUID = 6586114515564784388L;

            public double logPDF(double d, EmpiricalDistributionData empiricalDistributionData) {
                int n = empiricalDistributionData.values.length - 1;
                if (n == 0) {
                    return empiricalDistributionData.density[0];
                }
                if (d <= empiricalDistributionData.values[0]) {
                    double d2 = Math.max(0.0, (empiricalDistributionData.density[1] - empiricalDistributionData.density[0]) / (empiricalDistributionData.values[1] - empiricalDistributionData.values[0]));
                    return (d - empiricalDistributionData.values[0]) * d2 + empiricalDistributionData.density[0];
                }
                if (d >= empiricalDistributionData.values[n]) {
                    double d3 = Math.min(0.0, (empiricalDistributionData.density[n] - empiricalDistributionData.density[n - 1]) / (empiricalDistributionData.values[n] - empiricalDistributionData.values[n - 1]));
                    return (d - empiricalDistributionData.values[n]) * d3 + empiricalDistributionData.density[n];
                }
                return super.logPDF(d, empiricalDistributionData);
            }

            public final double sqr(double d) {
                return d * d;
            }

            public double gradientLogPdf(double d, EmpiricalDistributionData empiricalDistributionData) {
                int n = empiricalDistributionData.values.length;
                if (d <= empiricalDistributionData.values[0] || d >= empiricalDistributionData.values[n]) {
                    return 0.0;
                }
                return super.gradientLogPdf(d, empiricalDistributionData);
            }
        };
    }
}

