% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shannon.evaluate.core.R
\name{shannon.evaluate.core}
\alias{shannon.evaluate.core}
\title{Shannon-Weaver Diversity Index}
\usage{
shannon.evaluate.core(data, names, qualitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string}

\item{qualitative}{Name of columns with the qualitative traits as a character
vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
A data frame with the following columns. \item{Trait}{The qualitative
  trait.} \item{EC_H}{The Shannon-Weaver Diversity Index (\mjseqn{H'}) for
  EC.} \item{EC_H}{The Shannon-Weaver Diversity Index (\mjseqn{H'}) for CS.}
  \item{EC_Hmax}{The Maximum diversity value (\mjseqn{H'_{max}}) for EC.}
  \item{CS_Hmax}{The Maximum diversity value (\mjseqn{H'_{max}}) for CS.}
  \item{EC_EH}{The Shannon Equitability Index (\mjseqn{E_{H}}) for EC.}
  \item{CS_EH}{The Shannon Equitability Index (\mjseqn{E_{H}}) for CS.}
}
\description{
Compute the Shannon-Weaver Diversity Index (\mjseqn{H'}), Maximum diversity
(\mjseqn{H'_{max}}) and Shannon Equitability Index (\mjseqn{E_{H}})
\insertCite{shannon_mathematical_1949}{EvaluateCore} to compare the
phenotypic diversity for qualitative traits between entire collection (EC)
and core set (CS). \loadmathjax
}
\details{
Shannon-Weaver Diversity Index (\mjseqn{H'}) is computed as follows.

\mjsdeqn{H' = -\sum_{i=1}^{k}p_{i}log(p_{i})}

Where \mjseqn{p_{i}} denotes the proportion in the group \mjseqn{k}.

The maximum value of the index (\mjseqn{H'_{max}}) is \mjseqn{\ln(k)}. This
value occurs when each group has the same frequency.

The Shannon equitability index (\mjseqn{E_{H}}) is the Shannon diversity
index divided by the maximum diversity.

\mjsdeqn{E_{H} = \frac{H}{\ln{(k)}}}
}
\examples{

####################################
# Use data from R package ccChooser
####################################

library(ccChooser)
data("dactylis_CC")
data("dactylis_EC")

ec <- cbind(genotypes = rownames(dactylis_EC), dactylis_EC[, -1])
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) cut(x, breaks = 4))
ec[, c("X1", "X6", "X7")] <- lapply(ec[, c("X1", "X6", "X7")],
                                    function(x) factor(as.numeric(x)))
head(ec)

core <- rownames(dactylis_CC)

quant <- c("X2", "X3", "X4", "X5", "X8")
qual <- c("X1", "X6", "X7")

####################################
# EvaluateCore
####################################

shannon.evaluate.core(data = ec, names = "genotypes",
                      qualitative = qual, selected = core)


}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[psych:misc]{shannon}}
}
