% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EN_GetISIN_F.R
\name{EN_GetISIN_F}
\alias{EN_GetISIN_F}
\title{Get the DNA (ISIN and Market identifier) of a ticker from the funds list}
\usage{
EN_GetISIN_F(ticker)
}
\arguments{
\item{ticker}{The ticker to search for.}
}
\value{
A character
}
\description{
This function checks if the provided ticker is present in the specified columns of the funds list. If the ticker is found in the funds list, the function returns the DNA (ISIN and Market identifier) of the corresponding ticker. Otherwise, it returns 'Ticker not found'.
}
\examples{
\donttest{
library(httr)
library(jsonlite)
library(stringr)
library(jsonlite)

the_dna = EN_GetISIN_F("ACOMEA GLOBALE")
sub("-.*", "", the_dna) #To get only the ISIN

# Get Fund 'ASNU SMALL MIDCAPF' DNA
asnu_dna <- EN_GetISIN_F("ASN5")
print(asnu_dna)

# Get Fund 'COMPAM ACTIVE GLOB' DNA
EN_GetISIN_F("LU1275425897")
}

}
\seealso{
\code{\link{EN_GetISIN}} to get DNA of a giving Company or Index Ticker/Name/ISIN (Fund, Bond, and ETF are excluded), \code{\link{EN_Funds_List}} to get the list of funds quoted on Euronext markets, \code{\link{EN_GetISIN_B}} to get a giving Bond DNA, \code{\link{EN_GetISIN_Etf}} to get a giving ETF DNA.

Other ISIN Retrieval: 
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()}

Other Infos Retrieval: 
\code{\link{EN_Bonds_List_bis}()},
\code{\link{EN_Bonds_List}()},
\code{\link{EN_Etfs_List_bis}()},
\code{\link{EN_Etfs_List}()},
\code{\link{EN_Funds_List}()},
\code{\link{EN_GetISIN_B}()},
\code{\link{EN_GetISIN_Etf}()},
\code{\link{EN_Get_News}()},
\code{\link{EN_Indices_List}()},
\code{\link{EN_Stocks_List}()},
\code{\link{En_Market.Sumarry}()}
}
\concept{ISIN Retrieval}
\concept{Infos Retrieval}
