% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indqi.R
\name{indviab}
\alias{indviab}
\title{Ear Indexes}
\usage{
indviab(
  GEN,
  var1,
  var2,
  ylab = "Index",
  xlab = "Genotype",
  stat = "all",
  verbose = FALSE,
  plot = FALSE
)
}
\arguments{
\item{GEN}{The column with the name of the genotypes}

\item{var1}{The column containing the first variable}

\item{var2}{The column containing the second variable}

\item{ylab}{The name of the chart's Y axis}

\item{xlab}{The name of the chart's X axis}

\item{stat}{Logical argument. Use 'all' to return the values obtained for all
observations or 'mean' to return the mean per genotype.}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}

\item{plot}{Logical argument. Plot a graphic if 'TRUE'.}
}
\value{
Returns the index obtained between the reported variables. The higher
the index, the better the genotype.
}
\description{
Estimating the viability index from the combination of two field variables.
}
\examples{
library(EstimateBreed)

data("trigo")
#Ear viability index
index1 <- with(trigo,indviab(TEST,NGE,NEE))

#Ear harvest index
index2 <- with(trigo,indviab(TEST,MGE,ME))

#Spikelet deposition index in the ear
index3 <- with(trigo,indviab(TEST,NEE,CE))
}
\references{
Rigotti, E. J., Carvalho, I. R., Loro, M. V., Pradebon, L. C., Dalla Roza,
J. P., & Sangiovo, J. P. (2024). Seed and grain yield and quality of wheat
subjected to advanced harvest using a physiological ripening process.
Revista Engenharia na Agricultura - REVENG, 32, 54-64.
\doi{10.13083/reveng.v32i1.17394}
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
